/***************************************************************************
 * RT2x00 SourceForge Project - http://rt2x00.serialmonkey.com              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   Licensed under the GNU GPL                                            *
 *   Original code supplied under license from RaLink Inc, 2004.           *
 ***************************************************************************/

/***************************************************************************
 *	Module Name:	rt_config.h
 *
 *	Abstract:
 *
 *	Revision History:
 *	Who		When		What
 *	--------	----------	-------------------------------
 *	Name		Date		Modification logs
 *	Jan Lee		2005-06-01	Release
 *	RobinC		02-06-2005	usb_kill_urb fixes for kernels =>2.6.7
 *	MathiasK	04-07-2005	endian fix
 ***************************************************************************/

#ifndef	__RT_CONFIG_H__
#define	__RT_CONFIG_H__

#define PROFILE_PATH            "/etc/Wireless/RT2570STA/RT2570STA.dat"
#define NIC_DEVICE_NAME         "RT2500USBSTA"
#define DRV_MAJORVERSION	1
#define DRV_MINORVERSION	0
#define DRV_SUBVERSION		0
#define DRV_TESTVERSION		0
#define DRV_YEAR		2007
#define DRV_MONTH		5
#define DRV_DAY			6

#define DRV_NAME		"rt2570"
#define DRV_VERSION		"1.0.0 - CVS"
#define DRV_RELDATE		"CVS Release"


/* Operational parameters that are set at compile time. */
#if !defined(__OPTIMIZE__)  ||  !defined(__KERNEL__)
#warning  You must compile this file with the correct options!
#warning  See the last lines of the source file.
#error  You must compile this driver with "-O".
#endif

#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,25))	// N.A. earlier
#include <linux/moduleparam.h>	// Only need to explicitly include
#endif							// in early 2.6 series
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>		// For udelay, mdelay
#include <linux/wireless.h>
#include <linux/proc_fs.h>
#include <linux/if_arp.h>
#include <linux/ctype.h>
#include <linux/sched.h>
#include <linux/smp_lock.h>
#include <linux/kmod.h>

//usb header files
#include <linux/usb.h>

#if LINUX_VERSION_CODE >= 0x20407
#include <linux/mii.h>
#endif
#include <asm/processor.h>      /* Processor type for cache alignment. */
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/atomic.h>

// The type definition has to be placed before including rt2460.h
#ifndef ULONG
#define CHAR            signed char
#define INT             int
#define UINT            u32
#define ULONG           u32
#define USHORT          u16
#define UCHAR           u8

#define BOOLEAN         u8
//#define LARGE_INTEGER s64
#define VOID            void
#define LONG            int
#define ULONGLONG       u64
typedef VOID            *PVOID;
typedef CHAR            *PCHAR;
typedef UCHAR           *PUCHAR;
typedef USHORT		*PUSHORT;
typedef LONG            *PLONG;
typedef ULONG           *PULONG;

typedef union _LARGE_INTEGER {
    struct {
        ULONG LowPart;
        LONG HighPart;
    }vv;
    struct {
        ULONG LowPart;
        LONG HighPart;
    } u;
    s64 QuadPart;
} LARGE_INTEGER;

#endif

#define IN
#define OUT

#define TRUE        1
#define FALSE       0

#define ETH_LENGTH_OF_ADDRESS   6

#define NDIS_STATUS                             INT
#define NDIS_STATUS_SUCCESS                     0x00
#define NDIS_STATUS_FAILURE                     0x01
#define NDIS_STATUS_RESOURCES                   0x03
#define NDIS_STATUS_MEDIA_DISCONNECT            0x04
#define NDIS_STATUS_MEDIA_CONNECT               0x05
#define NDIS_STATUS_RESET                     0x06


//
//	Hardware related header files
//
#include	"rt2570.h"
#ifdef __BIG_ENDIAN
#define BIG_ENDIAN
#endif /* __BIG_ENDIAN */

//
//	Miniport defined header files
//
#include	"rtmp_type.h"
#include	"rtmp_def.h"
#include  "oid.h"
#include	"mlme.h"
#include  "md5.h"
#include  "wpa.h"
#include  "sha1.h"
#include	"rt2570sw.h"
#include  "rtusb.h"
#include	"rt2x00debug.h"

#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c) ((a)*65536+(b)*256+(c))
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,29)
static inline unsigned int jiffies_to_msecs(const unsigned long j)
{
#if HZ <= 1000 && !(1000 % HZ)
	return (1000 / HZ) * j;
#elif HZ > 1000 && !(HZ % 1000)
	return (j + (HZ / 1000) - 1)/(HZ / 1000);
#else
	return (j * 1000) / HZ;
#endif
}

static inline unsigned int jiffies_to_usecs(const unsigned long j)
{
#if HZ <= 1000 && !(1000 % HZ)
	return (1000000 / HZ) * j;
#elif HZ > 1000 && !(HZ % 1000)
	return (j*1000 + (HZ - 1000))/(HZ / 1000);
#else
	return (j * 1000000) / HZ;
#endif
}

static inline unsigned long msecs_to_jiffies(const unsigned int m)
{
	if (m > jiffies_to_msecs(MAX_JIFFY_OFFSET))
		return MAX_JIFFY_OFFSET;
#if HZ <= 1000 && !(1000 % HZ)
	return (m + (1000 / HZ) - 1) / (1000 / HZ);
#elif HZ > 1000 && !(HZ % 1000)
	return m * (HZ / 1000);
#else
	return (m * HZ + 999) / 1000;
#endif
}

static inline void msleep(unsigned long msecs)
{
        set_current_state(TASK_UNINTERRUPTIBLE);
        schedule_timeout(msecs_to_jiffies(msecs) + 1);
}
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
#define rtusb_submit_urb(purb) usb_submit_urb(purb, GFP_ATOMIC)
#else
#define rtusb_submit_urb(purb) usb_submit_urb(purb)
#endif

#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,7))
	#define usb_kill_urb  usb_unlink_urb
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22))
#define skb_reset_mac_header(skb) (skb->mac.raw = skb->data)

#define first_net_device()		dev_base
#define next_net_device(device)	((device)->next)

#endif


#define __BH
#define RHEL
#ifndef USB_ST_NOERROR
#define  USB_ST_NOERROR 0
#endif
#define INIT_FROM_EEPROM

#endif // __RT_CONFIG_H__
