#ifndef __RT_TESTS_H__
#define __RT_TESTS_H__

#include <linux/version.h>
#include <sys/syscall.h>

#if defined(__IGNORE_getcpu) || defined(RHEL_MAJOR)
#   ifdef __IGNORE_getcpu
#       define HAS_SCHED_GETCPU
#   else
#       undef HAS_SCHED_GETCPU
#   endif
#   include <bits/wordsize.h>
#   if __WORDSIZE == 64
#      include <asm/vsyscall.h>
#      define getcpu(cpu, node, cache) syscall(__NR_vgetcpu, cpu, node, cache)
#   else
#      define getcpu(cpu, node, cache) syscall(__NR_getcpu, cpu, node, cache)
#   endif
#else
#   define getcpu(cpu, node, cache) syscall(__NR_getcpu, cpu, node, cache)
#endif

#define gettid() syscall(__NR_gettid)

/* conversions */
#define USEC_PER_SEC 	1000000
#define NSEC_PER_SEC	1000000000
#define USEC_TO_NSEC(u) ((u) * 1000)
#define USEC_TO_SEC(u) 	((u) / USEC_PER_SEC)
#define NSEC_TO_USEC(n) ((n) / 1000)
#define SEC_TO_NSEC(s) 	((s) * NSEC_PER_SEC)
#define SEC_TO_USEC(s) 	((s) * USEC_PER_SEC)

#include "rt-utils.h"

#endif /* __RT_TESTS_H__ */
