<?php

require_once(__DIR__ . '/DealabsBridge.php');
class HotUKDealsBridge extends PepperBridgeAbstract {

	const NAME = 'HotUKDeals bridge';
	const URI = 'https://www.hotukdeals.com/';
	const DESCRIPTION = 'Return the HotUKDeals search result using keywords';
	const MAINTAINER = 'sysadminstory';
	const PARAMETERS = array(
		'Search by keyword(s))' => array (
			'q' => array(
				'name' => 'Keyword(s)',
				'type' => 'text',
				'required' => true
			),
			'hide_expired' => array(
				'name' => 'Hide expired deals',
				'type' => 'checkbox',
				'required' => true
			),
			'hide_local' => array(
				'name' => 'Hide local deals',
				'type' => 'checkbox',
				'title' => 'Hide deals in physical store',
				'required' => true
			),
			'priceFrom' => array(
				'name' => 'Minimal Price',
				'type' => 'text',
				'title' => 'Minmal Price in Pounds',
				'required' => false
			),
			'priceTo' => array(
				'name' => 'Maximum Price',
				'type' => 'text',
				'title' => 'Maximum Price in Pounds',
				'required' => false
			),
		),

		'Deals per group' => array(
			'group' => array(
				'name' => 'Group',
				'type' => 'list',
				'required' => true,
				'title' => 'Group whose deals must be displayed',
				'values' => array(
					'2DS' => '2ds',
					'3D Bluray' => '3d-bluray',
					'3D Glasses' => '3d-glasses',
					'3D Printer' => '3d-printer',
					'3DS' => '3ds',
					'3DS Games' => '3ds-games',
					'3D TV' => '3d-tv',
					'4G' => '4g',
					'4k Bluray' => '4k-bluray',
					'4k Monitor' => '4k-monitor',
					'4K TV' => '4k-tv',
					'7up' => '7up',
					'144Hz Monitor' => '144hz',
					'AA Batteries' => 'aa',
					'Acer' => 'acer',
					'Actifry' => 'actifry',
					'Action Camera' => 'action-camera',
					'Add On Item' => 'add-on-item',
					'Adidas' => 'adidas',
					'Adobe' => 'adobe',
					'Aftershave' => 'aftershave',
					'Air Bed' => 'air-bed',
					'Air Conditioner' => 'air-con',
					'Air Fryer' => 'air-fryer',
					'Airport Parking' => 'airport-parking',
					'AKG' => 'akg',
					'Alarm' => 'alarm',
					'Alcatel' => 'alcatel',
					'Alcohol' => 'alcohol',
					'Alienware' => 'alienware',
					'Alton Towers' => 'alton-towers',
					'Amazon Echo' => 'amazon-echo',
					'Amazon Fire Stick' => 'amazon-fire-stick',
					'Amazon Fire Tv' => 'fire-tv',
					'Amazon Pantry' => 'amazon-pantry',
					'Amazon Prime' => 'amazon-prime',
					'Amazon Warehouse' => 'amazon-warehouse',
					'AMD' => 'amd',
					'Amex' => 'amex',
					'Amiibo' => 'amiibo',
					'Amsterdam' => 'amsterdam',
					'Android' => 'android',
					'Android Tablet' => 'android-tablet',
					'Android TV' => 'android-tv',
					'Anker' => 'anker',
					'Apple' => 'apple',
					'Apple TV' => 'apple-tv',
					'Apple Watch' => 'apple-watch',
					'Armani' => 'armani',
					'Asics' => 'asics',
					'ASUS' => 'asus',
					'Audi' => 'audi',
					'Baby' => 'baby',
					'Baby & Kids' => 'kids',
					'Baby Monitor' => 'baby-monitor',
					'Baby Swing' => 'baby-swing',
					'Backpack' => 'backpack',
					'Bag' => 'bag',
					'Bank' => 'bank',
					'Barbour' => 'barbour',
					'Barcelona' => 'barcelona',
					'Bathroom' => 'bathroom',
					'Batman' => 'batman',
					'Battery' => 'battery',
					'Battlefield' => 'battlefield',
					'Battlefield 1' => 'battlefield-1',
					'BBQ' => 'bbq',
					'Bean To Cup' => 'bean-to-cup',
					'Beard Trimmer' => 'beard-trimmer',
					'Bed' => 'bed',
					'Bedding' => 'bedding',
					'Bed Frame' => 'bed-frame',
					'Beer' => 'beer',
					'Beko' => 'beko',
					'Belfast' => 'belfast',
					'Bench' => 'bench',
					'Berghaus' => 'berghaus',
					'Bike' => 'bike',
					'Bin' => 'bin',
					'Bioshock' => 'bioshock',
					'Black Ops 3' => 'black-ops-3',
					'Blackpool' => 'blackpool',
					'Blender' => 'blender',
					'Blinds' => 'blinds',
					'Bloodborne' => 'bloodborne',
					'Blu-Ray' => 'blu-ray',
					'Bluetooth Headphones' => 'bluetooth-headphones',
					'Bluetooth Speaker' => 'bluetooth-speaker',
					'BMW' => 'bmw',
					'Board Game' => 'board-game',
					'Boiler' => 'boiler',
					'Bosch' => 'bosch',
					'Bose' => 'bose',
					'Bourbon' => 'bourbon',
					'Boxers' => 'boxers',
					'Bra' => 'bra',
					'Braun' => 'braun',
					'Breakdown' => 'breakdown',
					'Brewdog' => 'brewdog',
					'Brita' => 'brita',
					'Broadband' => 'broadband',
					'BT' => 'bt',
					'Bt Sport' => 'bt-sport',
					'Buggy' => 'buggy',
					'Call Of Duty' => 'call-of-duty',
					'Camera' => 'camera',
					'Camera Lens' => 'lens',
					'Camping' => 'camping',
					'Candle' => 'candle',
					'Canon' => 'canon',
					'Canvas' => 'canvas',
					'Car' => 'car',
					'Caravan' => 'caravan',
					'Car Battery' => 'car-battery',
					'Car Hire' => 'car-hire',
					'Car Insurance' => 'car-insurance',
					'Car Lease' => 'car-lease',
					'Car Mats' => 'car-mats',
					'Carpet' => 'carpet',
					'Carpet Cleaner' => 'carpet-cleaner',
					'Car Seat' => 'car-seat',
					'Car Stereo' => 'car-stereo',
					'Casio' => 'casio',
					'Caterpillar Boots' => 'caterpillar',
					'Cat Food' => 'cat-food',
					'CCTV' => 'cctv',
					'Chainsaw' => 'chainsaw',
					'Chair' => 'chair',
					'Champagne' => 'champagne',
					'Charger' => 'charger',
					'Chessington' => 'chessington',
					'Chest Freezer' => 'chest-freezer',
					'Chocolate' => 'chocolate',
					'Chromebook' => 'chromebook',
					'Chromecast' => 'chromecast',
					'Cider' => 'cider',
					'Cinema' => 'cinema',
					'Cineworld' => 'cineworld',
					'Circular Saw' => 'circular-saw',
					'Circulon' => 'circulon',
					'Citizen' => 'citizen',
					'Clarins' => 'clarins',
					'Clarks' => 'clarks',
					'Clinique' => 'clinique',
					'Clothes' => 'clothes',
					'Coat' => 'coat',
					'Coffee' => 'coffee',
					'Coffee Machine' => 'coffee-machine',
					'Coke' => 'coke',
					'Compost' => 'compost',
					'Computers' => 'computers',
					'Converse' => 'converse',
					'Cooker' => 'cooker',
					'Cordless Phone' => 'cordless-phone',
					'Corsair' => 'corsair',
					'Cot' => 'cot',
					'CPU' => 'cpu',
					'Crash Bandicoot' => 'crash-bandicoot',
					'Credit Card' => 'credit-card',
					'Cricket' => 'cricket',
					'Crisps' => 'crisps',
					'Crocs' => 'crocs',
					'Cruise' => 'cruise',
					'Cuprinol' => 'cuprinol',
					'Cutlery' => 'cutlery',
					'Dab Radio' => 'dab-radio',
					'Dark Souls' => 'dark-souls',
					'Dark Souls 3' => 'dark-souls-3',
					'Dash Cam' => 'dash-cam',
					'Days Out' => 'days-out',
					'DDR3' => 'ddr3',
					'DDR4' => 'ddr4',
					'Deezer' => 'deezer',
					'Dehumidifier' => 'dehumidifier',
					'Dell' => 'dell',
					'Delonghi' => 'delonghi',
					'Denon' => 'denon',
					'Desk' => 'desk',
					'Desktop' => 'desktop',
					'Destiny' => 'destiny',
					'Destiny 2' => 'destiny-2',
					'Deus Ex' => 'deus-ex',
					'Dewalt' => 'dewalt',
					'Digital Camera' => 'digital-camera',
					'Dining Table' => 'dining-table',
					'Dinner Set' => 'dinner-set',
					'Dirt 4' => 'dirt-4',
					'Dishonored 2' => 'dishonored-2',
					'Dishwasher' => 'dishwasher',
					'Disney' => 'disney',
					'Disney Infinity' => 'disney-infinity',
					'Disneyland' => 'disneyland',
					'DIY' => 'diy',
					'Doctor Who' => 'doctor-who',
					'Dog' => 'dog',
					'Dog Bed' => 'dog-bed',
					'Dolce Gusto' => 'dolce-gusto',
					'DOOM' => 'doom',
					'Dremel' => 'dremel',
					'Dress' => 'dress',
					'Drill' => 'drill',
					'Drone' => 'drone',
					'Dryer' => 'dryer',
					'DSLR Camera' => 'dslr',
					'Dubai' => 'dubai',
					'Dulux' => 'dulux',
					'Durex' => 'durex',
					'Duvet' => 'duvet',
					'DVD' => 'dvd',
					'DVD Player' => 'dvd-player',
					'Dying Light' => 'dying-light',
					'Dyson' => 'dyson',
					'Dyson V6' => 'dyson-v6',
					'Dyson V8' => 'dyson-v8',
					'E-Cig' => 'e-cig',
					'EA' => 'ea',
					'EA Access' => 'ea-access',
					'Earphones' => 'earphones',
					'Earrings' => 'earrings',
					'Eastpak' => 'eastpak',
					'eBook' => 'ebook',
					'Eco-Drive' => 'eco-drive',
					'Ecobubble' => 'ecobubble',
					'Edifice' => 'edifice',
					'Edinburgh' => 'edinburgh',
					'EE' => 'ee',
					'Egg' => 'egg',
					'Egypt' => 'egypt',
					'Elder Scrolls' => 'elder-scrolls',
					'Electric Bike' => 'electric-bike',
					'Electric Cooker' => 'electric-cooker',
					'Electric Fires' => 'electric-fire',
					'Electric Shower' => 'electric-shower',
					'Electric Toothbrush' => 'electric-toothbrush',
					'Electronics' => 'electronics',
					'Elemis' => 'elemis',
					'Elephone' => 'elephone',
					'Elgato' => 'elgato',
					'Elite Dangerous' => 'elite-dangerous',
					'Emirates' => 'emirates',
					'Eneloop' => 'eneloop',
					'Energy' => 'energy',
					'Engine Oil' => 'engine-oil',
					'Entertainment' => 'entertainment',
					'Epilator' => 'epilator',
					'Epson' => 'epson',
					'eReader' => 'ereader',
					'Espresso' => 'espresso',
					'Estee Lauder' => 'estee-lauder',
					'Ethernet' => 'ethernet',
					'Eurostar' => 'eurostar',
					'Eurotunnel' => 'eurotunnel',
					'EVGA' => 'evga',
					'Extension Lead' => 'extension-lead',
					'External Hard Drive' => 'external-hard-drive',
					'Fairy' => 'fairy',
					'Fallout' => 'fallout',
					'Fallout 4' => 'fallout-4',
					'Fan' => 'fan',
					'Fancy Dress' => 'fancy-dress',
					'Far Cry' => 'far-cry',
					'Far Cry 4' => 'far-cry-4',
					'Far Cry Primal' => 'far-cry-primal',
					'Fashion' => 'fashion',
					'Fathers Day' => 'fathers-day',
					'Felix' => 'felix',
					'Fence' => 'fence',
					'Fender Guitars' => 'fender',
					'Ferrero Rocher' => 'ferrero-rocher',
					'Ferry' => 'ferry',
					'Festival' => 'festival',
					'Fiat' => 'fiat',
					'FIFA' => 'fifa',
					'FIFA 17' => 'fifa-17',
					'FIFA 18' => 'fifa-18',
					'Figures' => 'figures',
					'Final Fantasy' => 'final-fantasy',
					'Finance & Utilities' => 'personal-finance',
					'Finish' => 'finish',
					'Finlux' => 'finlux',
					'Fire Emblem' => 'fire-emblem',
					'Fire Pit' => 'fire-pit',
					'Fireplace' => 'fireplace',
					'Fish' => 'fish',
					'Fisher Price' => 'fisher-price',
					'Fishing' => 'fishing',
					'Fiskars' => 'fiskars',
					'Fitbit' => 'fitbit',
					'Fitbit Alta' => 'fitbit-alta',
					'Fitbit Blaze' => 'fitbit-blaze',
					'Fitbit Charge 2' => 'fitbit-charge-2',
					'Fitness Tracker' => 'fitness-tracker',
					'Flamingo Land' => 'flamingo-land',
					'Flask' => 'flask',
					'Fleece' => 'fleece',
					'Flight' => 'flight',
					'Flip Flops' => 'flip-flops',
					'Floodlight' => 'floodlight',
					'Flooring' => 'flooring',
					'Florida' => 'florida',
					'Flowers' => 'flowers',
					'Flybe' => 'flybe',
					'Flymo' => 'flymo',
					'Food' => 'food',
					'Food Mixer' => 'food-mixer',
					'Food Processor' => 'food-processor',
					'Football' => 'football',
					'Football Boots' => 'football-boots',
					'Football Manager' => 'football-manager',
					'Football Shirt' => 'football-shirt',
					'Ford' => 'ford',
					'For Honor' => 'for-honor',
					'Formula 1' => 'f1',
					'Forza' => 'forza',
					'Forza Horizon' => 'forza-horizon',
					'Forza Horizon 3' => 'forza-horizon-3',
					'Fossil' => 'fossil',
					'Fosters' => 'fosters',
					'Foundation' => 'foundation',
					'France' => 'france',
					'Fred Perry' => 'fred-perry',
					'Freebies' => 'freebies',
					'Freesat' => 'freesat',
					'Freeview' => 'freeview',
					'Freezer' => 'freezer',
					'Fridge' => 'fridge',
					'Fridge Freezer' => 'fridge-freezer',
					'Frozen' => 'frozen',
					'Fruit' => 'fruit',
					'Fryer' => 'fryer',
					'Frying Pan' => 'frying-pan',
					'Fujifilm' => 'fuji',
					'Funko Pop' => 'funko-pop',
					'Furby' => 'furby',
					'Furniture' => 'furniture',
					'Fusion' => 'fusion',
					'G-Shock' => 'g-shock',
					'G-Sync Monitor' => 'g-sync',
					'Game Of Thrones' => 'game-of-thrones',
					'Gaming' => 'gaming',
					'Gaming Chair' => 'gaming-chair',
					'Gaming Controller' => 'controller',
					'Gaming Headset' => 'gaming-headset',
					'Gaming Keyboard' => 'gaming-keyboard',
					'Gaming Laptop' => 'gaming-laptop',
					'Gaming Monitor' => 'gaming-monitor',
					'Gaming PC' => 'gaming-pc',
					'Garage' => 'garage',
					'Garden' => 'garden',
					'Garden Furniture' => 'garden-furniture',
					'Garmin' => 'garmin',
					'Gas' => 'gas',
					'Gas Cooker' => 'gas-cooker',
					'Gatwick' => 'gatwick',
					'Gazebo' => 'gazebo',
					'Gazelle' => 'gazelle',
					'GBK' => 'gbk',
					'Gears Of War' => 'gears-of-war',
					'Gears Of War 4' => 'gears-of-war-4',
					'GeForce' => 'geforce',
					'George Foreman' => 'george-foreman',
					'Geox' => 'geox',
					'GHD' => 'ghd',
					'Ghostbusters' => 'ghostbusters',
					'Ghost Recon' => 'ghost-recon',
					'Gibson Guitars' => 'gibson',
					'Giffgaff' => 'giffgaff',
					'Gift Card' => 'gift-card',
					'Gifts' => 'gifts',
					'Gift Set' => 'gift-set',
					'Gilet' => 'gilet',
					'Gillette' => 'gillette',
					'Gimbal' => 'gimbal',
					'Gin' => 'gin',
					'Glasgow' => 'glasgow',
					'Glasses' => 'glasses',
					'Gloves' => 'gloves',
					'Glue Gun' => 'glue-gun',
					'Gluten Free' => 'gluten-free',
					'Goggles' => 'goggles',
					'Go Kart' => 'go-kart',
					'Golf' => 'golf',
					'Golf Balls' => 'golf-balls',
					'Golf Clubs' => 'golf-clubs',
					'Goodfellas' => 'goodfellas',
					'Google' => 'google',
					'Google Home' => 'google-home',
					'Google Pixel' => 'google-pixel',
					'Go Outdoors' => 'go-outdoors',
					'GoPro' => 'gopro',
					'Graco' => 'graco',
					'Grand National' => 'grand-national',
					'Graphics Card' => 'graphics-card',
					'Gravity Rush' => 'gravity-rush',
					'Graze' => 'graze',
					'Greece' => 'greece',
					'Greenhouse' => 'greenhouse',
					'Greggs' => 'greggs',
					'Grey Goose' => 'grey-goose',
					'Grill' => 'grill',
					'Grinder' => 'grinder',
					'Grobag' => 'grobag',
					'Groceries' => 'groceries',
					'GTA' => 'gta',
					'GTA V' => 'gta-v',
					'Gtx 970' => 'gtx-970',
					'GTX 1060' => 'gtx-1060',
					'GTX 1070' => 'gtx-1070',
					'GTX 1080' => 'gtx-1080',
					'Guardians Of The Galaxy' => 'guardians-of-the-galaxy',
					'Gucci' => 'gucci',
					'Guinness' => 'guinness',
					'Guitar' => 'guitar',
					'Guitar Hero' => 'guitar-hero',
					'Gullivers' => 'gullivers',
					'Gym' => 'gym',
					'Gym Membership' => 'gym-membership',
					'H1z1' => 'h1z1',
					'Habitat' => 'habitat',
					'Hair' => 'hair',
					'Hair Clipper' => 'hair-clipper',
					'Hair Dryer' => 'hair-dryer',
					'Hair Dye' => 'hair-dye',
					'Halifax' => 'halifax',
					'Halo' => 'halo',
					'Halo 5' => 'halo-5',
					'Hammer' => 'hammer',
					'Hammock' => 'hammock',
					'Hamper' => 'hamper',
					'Handbag' => 'handbag',
					'Hand Mixer' => 'hand-mixer',
					'Happyland' => 'happyland',
					'Hard Drive' => 'hard-drive',
					'Haribo' => 'haribo',
					'Harman Kardon' => 'harman-kardon',
					'Harmony' => 'harmony',
					'Harry Potter' => 'harry-potter',
					'Hat' => 'hat',
					'Hatchimals' => 'hatchimals',
					'Hayfever' => 'hayfever',
					'Hdr Tv' => 'hdr-tv',
					'HD TV' => 'hd-tv',
					'Headboard' => 'headboard',
					'Headphones' => 'headphones',
					'Headset' => 'headset',
					'Health & Beauty' => 'beauty',
					'Heater' => 'heater',
					'Hedge Trimmer' => 'hedge-trimmer',
					'Heineken' => 'heineken',
					'Heinz' => 'heinz',
					'Helmet' => 'helmet',
					'Hermes' => 'hermes',
					'Highchair' => 'highchair',
					'Hiking' => 'hiking',
					'Hilton' => 'hilton',
					'Hisense' => 'hisense',
					'Hitachi' => 'hitachi',
					'Hitman' => 'hitman',
					'Hive' => 'hive',
					'Hob' => 'hob',
					'Holiday Inn' => 'holiday-inn',
					'Holidays & Leisure' => 'holiday',
					'Home & Garden' => 'home',
					'Home Cinema' => 'home-cinema',
					'Homedics' => 'homedics',
					'Homefront' => 'homefront',
					'Homeplug' => 'homeplug',
					'Home Security' => 'home-security',
					'Honey' => 'honey',
					'Honeywell' => 'honeywell',
					'Hong Kong' => 'hong-kong',
					'Honor' => 'honor',
					'Honor 6x' => 'honor-6x',
					'Hoodie' => 'hoodie',
					'Hoover' => 'hoover',
					'Horizon Zero Dawn' => 'horizon-zero-dawn',
					'Hornby' => 'hornby',
					'Hose' => 'hose',
					'Hotel' => 'hotel',
					'Hotpoint' => 'hotpoint',
					'Hot Tub' => 'hot-tub',
					'Hot Wheels' => 'hot-wheels',
					'Hozelock' => 'hozelock',
					'HP' => 'hp',
					'HP Envy' => 'hp-envy',
					'HP Laptop' => 'hp-laptop',
					'H Samuel' => 'h-samuel',
					'HTC' => 'htc',
					'HTC 10' => 'htc-10',
					'HTC Vive' => 'htc-vive',
					'Huawei' => 'huawei',
					'Huawei P9' => 'huawei-p9',
					'Huggies' => 'huggies',
					'Hugo Boss' => 'hugo-boss',
					'Humax' => 'humax',
					'Humidifier' => 'humidifier',
					'Hunter' => 'hunter',
					'Hydro 5' => 'hydro-5',
					'Hyperx' => 'hyperx',
					'Hyundai' => 'hyundai',
					'Iams Pet Food' => 'iams',
					'Ibiza' => 'ibiza',
					'Icandy' => 'icandy',
					'Ice Cream' => 'ice-cream',
					'Ice Cream Maker' => 'ice-cream-maker',
					'Imaginext' => 'imaginext',
					'Impact Driver' => 'impact-driver',
					'Indesit' => 'indesit',
					'India' => 'india',
					'Inflatable' => 'inflatable',
					'Injustice' => 'injustice',
					'Ink' => 'ink',
					'Inner Tube' => 'inner-tube',
					'Instant Ink' => 'instant-ink',
					'Insulation' => 'insulation',
					'Insurance' => 'insurance',
					'Intel' => 'intel',
					'Intel Atom' => 'atom',
					'Intel i3' => 'i3',
					'Intel i5' => 'i5',
					'Intel i7' => 'i7',
					'Internal Hard Drive' => 'internal-hard-drive',
					'Internet' => 'internet',
					'In The Night Garden' => 'in-the-night-garden',
					'iOS' => 'ios',
					'iPad' => 'ipad',
					'iPad Air' => 'ipad-air',
					'iPad Case' => 'ipad-case',
					'iPad Mini' => 'ipad-mini',
					'iPad Pro' => 'ipad-pro',
					'Ip Camera' => 'ip-camera',
					'iPhone' => 'iphone',
					'iPhone 5S' => 'iphone-5s',
					'iPhone 6' => 'iphone-6',
					'iPhone 6 Plus' => 'iphone-6-plus',
					'iPhone 6s' => 'iphone-6s',
					'iPhone 6s Plus' => 'iphone-6s-plus',
					'iPhone 7' => 'iphone-7',
					'iPhone 7 Plus' => 'iphone-7-plus',
					'iPhone Case' => 'iphone-case',
					'Iphone SE' => 'iphone-se',
					'iPod' => 'ipod',
					'iPod Nano' => 'ipod-nano',
					'iPod Touch' => 'ipod-touch',
					'Ireland' => 'ireland',
					'Irn Bru' => 'irn-bru',
					'Iron' => 'iron',
					'Ironing Board' => 'ironing-board',
					'Isle Of Wight' => 'isle-of-wight',
					'Isofix' => 'isofix',
					'Issey Miyake' => 'issey-miyake',
					'Italy' => 'italy',
					'iTunes' => 'itunes',
					'ITV' => 'itv',
					'Jabra' => 'jabra',
					'Jack Daniels' => 'jack-daniels',
					'Jacket' => 'jacket',
					'Jack Wills' => 'jack-wills',
					'Jack Wolfskin' => 'jack-wolfskin',
					'Jaguar' => 'jaguar',
					'Jamaica' => 'jamaica',
					'Jameson' => 'jameson',
					'Japan' => 'japan',
					'Jawbone' => 'jawbone',
					'Jaybird' => 'jaybird',
					'JBL' => 'jbl',
					'Jeans' => 'jeans',
					'Jewellery' => 'jewellery',
					'Jigsaw' => 'jigsaw',
					'Jim Beam' => 'jim-beam',
					'Jimmy Choo' => 'jimmy-choo',
					'Joop' => 'joop',
					'Jordan' => 'jordan',
					'Joseph Joseph' => 'joseph-joseph',
					'Joules' => 'joules',
					'Juice' => 'juice',
					'Juicer' => 'juicer',
					'Jumper' => 'jumper',
					'Jumperoo' => 'jumperoo',
					'Jura' => 'jura',
					'Just Cause 3' => 'just-cause-3',
					'Just Dance' => 'just-dance',
					'JVC' => 'jvc',
					'Karcher' => 'karcher',
					'Kaspersky' => 'kaspersky',
					'Kayak' => 'kayak',
					'Keg' => 'keg',
					'Kenwood' => 'kenwood',
					'Kenwood kMix' => 'kmix',
					'Keter' => 'keter',
					'Kettle' => 'kettle',
					'Kettlebell' => 'kettlebell',
					'Keyboard' => 'keyboard',
					'Kia' => 'kia',
					'Kickers' => 'kickers',
					'Kids Bike' => 'kids-bike',
					'Kinder' => 'kinder',
					'Kindle' => 'kindle',
					'Kindle Fire' => 'kindle-fire',
					'Kindle Paperwhite' => 'kindle-paperwhite',
					'Kinect' => 'kinect',
					'Kingdom Hearts' => 'kingdom-hearts',
					'King Size' => 'king-size',
					'Kirby' => 'kirby',
					'Kitchen' => 'kitchen',
					'KitchenAid' => 'kitchenaid',
					'Kitchen Roll' => 'kitchen-roll',
					'Kitsound' => 'kitsound',
					'Knickers' => 'knickers',
					'Knife' => 'knife',
					'Kobo' => 'kobo',
					'Kodi' => 'kodi',
					'Kopparberg' => 'kopparberg',
					'Kraken' => 'kraken',
					'Krakow' => 'krakow',
					'Krispy Kreme' => 'krispy-kreme',
					'Kurt Geiger' => 'kurt-geiger',
					'Lacoste' => 'lacoste',
					'Ladder' => 'ladder',
					'Lamb' => 'lamb',
					'Laminate' => 'laminate',
					'Lamp' => 'lamp',
					'Lancome' => 'lancome',
					'Laptop' => 'laptop',
					'Laser Printer' => 'laser-printer',
					'Laura Ashley' => 'laura-ashley',
					'Lavazza' => 'lavazza',
					'Lavender' => 'lavender',
					'Lawnmower' => 'lawnmower',
					'Lay-Z-Spa' => 'lay-z-spa',
					'Le Creuset' => 'le-creuset',
					'LED Bulbs' => 'led-bulbs',
					'LED TV' => 'led-tv',
					'Leeds' => 'leeds',
					'Lego' => 'lego',
					'Lego City' => 'lego-city',
					'Lego Dimensions' => 'lego-dimensions',
					'Lego Friends' => 'lego-friends',
					'Legoland' => 'legoland',
					'Lego Star Wars' => 'lego-star-wars',
					'Lego Technic' => 'lego-technic',
					'Leicester' => 'leicester',
					'Lenovo' => 'lenovo',
					'Lenovo Tablet' => 'lenovo-tablet',
					'Lenovo Yoga' => 'lenovo-yoga',
					'Levi' => 'levi',
					'LG' => 'lg',
					'LG G5' => 'lg-g5',
					'LG G6' => 'lg-g6',
					'LG TV' => 'lg-tv',
					'Light' => 'light',
					'Lighting' => 'lighting',
					'Lightning Cable' => 'lightning-cable',
					'Lindor' => 'lindor',
					'Lindt' => 'lindt',
					'Lingerie' => 'lingerie',
					'Linx' => 'linx',
					'Little Tikes' => 'little-tikes',
					'Liverpool' => 'liverpool',
					'Logitech' => 'logitech',
					'London' => 'london',
					'London Eye' => 'london-eye',
					'London Zoo' => 'london-zoo',
					'Lottery' => 'lottery',
					'Lounger' => 'lounger',
					'Lurpak' => 'lurpak',
					'Lynx' => 'lynx',
					'MacBook' => 'macbook',
					'MacBook Air' => 'macbook-air',
					'MacBook Pro' => 'macbook-pro',
					'Mac Mini' => 'mac-mini',
					'Mad Max' => 'mad-max',
					'Mafia 3' => 'mafia-3',
					'Magazine' => 'magazine',
					'Magimix' => 'magimix',
					'Majorca' => 'majorca',
					'Make Up' => 'make-up',
					'Makita' => 'makita',
					'Maldives' => 'maldives',
					'Manchester' => 'manchester',
					'Manfrotto' => 'manfrotto',
					'Marc Jacobs' => 'marc-jacobs',
					'Mario' => 'mario',
					'Mario Kart' => 'mario-kart',
					'Mario Kart 8' => 'mario-kart-8',
					'Mario Kart 8 Deluxe' => 'mario-kart-8-deluxe',
					'Marvel' => 'marvel',
					'Mascara' => 'mascara',
					'Massage' => 'massage',
					'Mass Effect' => 'mass-effect',
					'Mass Effect Andromeda' => 'mass-effect-andromeda',
					'Maternity' => 'maternity',
					'Mattress' => 'mattress',
					'Mattress Topper' => 'mattress-topper',
					'Mavic' => 'mavic',
					'Maxi Cosi' => 'maxi-cosi',
					'Meat' => 'meat',
					'Mechanical Keyboard' => 'mechanical-keyboard',
					'Medion' => 'medion',
					'Memory Foam' => 'memory-foam',
					'Mens Boots' => 'mens-boots',
					'Mens Fashion' => 'mens-clothing',
					'Mens Shoes' => 'mens-shoes',
					'Mercedes' => 'mercedes',
					'Merlin' => 'merlin',
					'Merrell' => 'merrell',
					'Mexico' => 'mexico',
					'Michael Kors' => 'michael-kors',
					'Microphone' => 'microphone',
					'Micro SD' => 'micro-sd',
					'Microserver' => 'microserver',
					'Microsoft' => 'microsoft',
					'Microsoft Office' => 'microsoft-office',
					'Microwave' => 'microwave',
					'Miele' => 'miele',
					'Milwaukee' => 'milwaukee',
					'Minecraft' => 'minecraft',
					'Mini' => 'mini',
					'Mini Fridge' => 'mini-fridge',
					'Mini PC' => 'mini-pc',
					'Mirror' => 'mirror',
					'Mitre Saw' => 'mitre-saw',
					'Mobile Broadband' => 'mobile-broadband',
					'Mobile Contract' => 'mobile-contract',
					'Mobile Phone' => 'mobile-phone',
					'Mobiles' => 'mobiles',
					'Molton Brown' => 'molton-brown',
					'Monitor' => 'monitor',
					'Monopoly' => 'monopoly',
					'Monsoon' => 'monsoon',
					'Mop' => 'mop',
					'Morocco' => 'morocco',
					'Mortgage' => 'mortgage',
					'Moses Basket' => 'moses-basket',
					'Mot' => 'mot',
					'Motherboard' => 'motherboard',
					'Moto 360' => 'moto-360',
					'Moto G' => 'moto-g',
					'Moto G4' => 'moto-g4',
					'Moto G5' => 'moto-g5',
					'Motorcycle' => 'motorcycle',
					'Motorola' => 'motorola',
					'Moto Z' => 'moto-z',
					'Mountain Bike' => 'mountain-bike',
					'Mouse' => 'mouse',
					'Mouse Mat' => 'mouse-mat',
					'Movie' => 'movie',
					'MP3 Player' => 'mp3-player',
					'MSI' => 'msi',
					'Mug' => 'mug',
					'Multitool' => 'multitool',
					'Music' => 'music',
					'My Little Pony' => 'my-little-pony',
					'Nandos' => 'nandos',
					'NAS' => 'nas',
					'National Express' => 'national-express',
					'National Trust' => 'national-trust',
					'Necklace' => 'necklace',
					'Nectar' => 'nectar',
					'Neff' => 'neff',
					'Nerf' => 'nerf',
					'Nescafe' => 'nescafe',
					'Nespresso' => 'nespresso',
					'Nest' => 'nest',
					'Netflix' => 'netflix',
					'Netgear' => 'netgear',
					'Netgear Arlo' => 'arlo',
					'New Balance' => 'new-balance',
					'Newcastle' => 'newcastle',
					'New Look' => 'new-look',
					'New York' => 'new-york',
					'Nextbase' => 'nextbase',
					'Nexus' => 'nexus',
					'NFL' => 'nfl',
					'Nier' => 'nier',
					'Nike' => 'nike',
					'Nike Air Max' => 'nike-air-max',
					'Nikon' => 'nikon',
					'Nilfisk' => 'nilfisk',
					'Ninja' => 'ninja',
					'Nintendo' => 'nintendo',
					'Nintendo DS' => 'nintendo-ds',
					'Nintendo eShop' => 'eshop',
					'Nintendo Switch' => 'nintendo-switch',
					'Nioh' => 'nioh',
					'Nissan' => 'nissan',
					'Nivea' => 'nivea',
					'Nokia' => 'nokia',
					'North Face' => 'north-face',
					'Norton' => 'norton',
					'Note 4' => 'note-4',
					'Now TV' => 'now-tv',
					'Nursery' => 'nursery',
					'Nus' => 'nus',
					'Nutella' => 'nutella',
					'Nutribullet' => 'nutribullet',
					'Nutri Ninja' => 'nutri-ninja',
					'NVIDIA' => 'nvidia',
					'O2' => 'o2',
					'O2 Refresh' => 'o2-refresh',
					'Oak' => 'oak',
					'Oakley' => 'oakley',
					'Oculus' => 'oculus',
					'Odeon' => 'odeon',
					'Office' => 'office',
					'Office Chair' => 'office-chair',
					'OLED TV' => 'oled',
					'Olympus' => 'olympus',
					'Oneplus' => 'oneplus',
					'Onkyo' => 'onkyo',
					'Oral-B' => 'oral-b',
					'Origin' => 'origin',
					'Orlando' => 'orlando',
					'Osprey' => 'osprey',
					'Ottoman' => 'ottoman',
					'Outdoor' => 'outdoor',
					'Oven' => 'oven',
					'Overwatch' => 'overwatch',
					'Paddling Pool' => 'paddling-pool',
					'Paint' => 'paint',
					'Pampers' => 'pampers',
					'Pan' => 'pan',
					'Panasonic' => 'panasonic',
					'Panasonic Lumix' => 'lumix',
					'Pandora' => 'pandora',
					'Papa Johns' => 'papa-johns',
					'Parasol' => 'parasol',
					'Parcel' => 'parcel',
					'Paris' => 'paris',
					'Parking' => 'parking',
					'Paw Patrol' => 'paw-patrol',
					'PAYG' => 'payg',
					'Paypal' => 'paypal',
					'PC' => 'pc',
					'PC Case' => 'pc-case',
					'PC Game' => 'pc-game',
					'Pebble' => 'pebble',
					'Peppa Pig' => 'peppa-pig',
					'Pepsi' => 'pepsi',
					'Perfume' => 'perfume',
					'Persona' => 'persona',
					'Persona 5' => 'persona-5',
					'Petrol' => 'petrol',
					'Philips' => 'philips',
					'Philips Hue' => 'philips-hue',
					'Phones' => 'phone',
					'Photo' => 'photo',
					'Piano' => 'piano',
					'Pillow' => 'pillow',
					'Pizza' => 'pizza',
					'Plant' => 'plant',
					'Playhouse' => 'playhouse',
					'Playmobil' => 'playmobil',
					'Playstation' => 'playstation',
					'Playstation Plus' => 'playstation-plus',
					'Playstation VR' => 'playstation-vr',
					'Pokemon' => 'pokemon',
					'Pool' => 'pool',
					'Power Bank' => 'power-bank',
					'Powerline' => 'powerline',
					'Power Rangers' => 'power-rangers',
					'Pram' => 'pram',
					'Pressure Cooker' => 'pressure-cooker',
					'Pressure Washer' => 'pressure-washer',
					'Printer' => 'printer',
					'Projector' => 'projector',
					'Protein' => 'protein',
					'PS3' => 'ps3',
					'PS4' => 'ps4',
					'PS4 Controller' => 'ps4-controller',
					'PS4 Games' => 'ps4-games',
					'PS4 Headset' => 'ps4-headset',
					'PS4 Pro' => 'ps4-pro',
					'PS4 Slim' => 'ps4-slim',
					'PSN' => 'psn',
					'PSU' => 'psu',
					'PS Vita' => 'ps-vita',
					'Puma' => 'puma',
					'Pushchair' => 'pushchair',
					'Qnap' => 'qnap',
					'Quorn' => 'quorn',
					'Rab' => 'rab',
					'Radiator' => 'radiator',
					'Radio' => 'radio',
					'Radley' => 'radley',
					'Railcard' => 'railcard',
					'Ralph Lauren' => 'ralph-lauren',
					'RAM' => 'ram',
					'Raspberry Pi' => 'raspberry-pi',
					'Rattan Garden Furniture' => 'rattan',
					'Ray Ban' => 'ray-ban',
					'Razer' => 'razer',
					'Razor' => 'razor',
					'Reebok' => 'reebok',
					'Resident Evil' => 'resident-evil',
					'Resident Evil 7' => 'resident-evil-7',
					'Rice' => 'rice',
					'Ring' => 'ring',
					'Road Bike' => 'road-bike',
					'Rocket League' => 'rocket-league',
					'Rogue One' => 'rogue-one',
					'Roku' => 'roku',
					'Rolex' => 'rolex',
					'Roof Box' => 'roof-box',
					'Roses' => 'roses',
					'Rotary' => 'rotary',
					'Router' => 'router',
					'Rug' => 'rug',
					'Rum' => 'rum',
					'Running' => 'running',
					'RX 480' => 'rx-480',
					'Ryanair' => 'ryanair',
					'Ryobi' => 'ryobi',
					'Sale' => 'sale',
					'Salmon' => 'salmon',
					'Salomon' => 'salomon',
					'Samsonite' => 'samsonite',
					'Samsung' => 'samsung',
					'Samsung Galaxy' => 'samsung-galaxy',
					'Samsung Galaxy S7' => 'samsung-galaxy-s7',
					'Samsung Galaxy S7 Edge' => 'samsung-galaxy-s7-edge',
					'Samsung Galaxy S8' => 'samsung-galaxy-s8',
					'Samsung Galaxy S8 Plus' => 'samsung-s8-plus',
					'Samsung Gear' => 'samsung-gear',
					'Samsung TV' => 'samsung-tv',
					'Sandals' => 'sandals',
					'Sander' => 'sander',
					'SanDisk' => 'sandisk',
					'Sat Nav' => 'sat-nav',
					'Saw' => 'saw',
					'Scalextric' => 'scalextric',
					'Scooter' => 'scooter',
					'Screenwash' => 'screenwash',
					'Screwdriver' => 'screwdriver',
					'SD Card' => 'sd-card',
					'SDXC' => 'sdxc',
					'Seagate' => 'seagate',
					'Seat' => 'seat',
					'Security Camera' => 'security-camera',
					'Seeds' => 'seeds',
					'Seiko' => 'seiko',
					'Sennheiser' => 'sennheiser',
					'Server' => 'server',
					'Sewing Machine' => 'sewing-machine',
					'Shadow Of Mordor' => 'shadow-of-mordor',
					'Shark' => 'shark',
					'Sharpie' => 'sharpie',
					'Shaver' => 'shaver',
					'Shed' => 'shed',
					'Shelves' => 'shelves',
					'Shirt' => 'shirt',
					'Shoes' => 'shoe',
					'Shopkins' => 'shopkins',
					'Shorts' => 'shorts',
					'Shower' => 'shower',
					'Shredder' => 'shredder',
					'Sideboard' => 'sideboard',
					'Sim' => 'sim',
					'Sim Free' => 'sim-free',
					'Sim Only' => 'sim-only',
					'Sink' => 'sink',
					'Skechers' => 'skechers',
					'Ski' => 'ski',
					'Skoda' => 'skoda',
					'Sky' => 'sky',
					'Skylanders' => 'skylanders',
					'Skyrim' => 'skyrim',
					'Sleeping Bag' => 'sleeping-bag',
					'Slide' => 'slide',
					'Slimming World' => 'slimming-world',
					'Slippers' => 'slippers',
					'Slow Cooker' => 'slow-cooker',
					'SLR Camera' => 'slr',
					'Smart' => 'smart',
					'Smartphone' => 'smartphone',
					'Smartthings' => 'smartthings',
					'Smart TV' => 'smart-tv',
					'Smartwatch' => 'smartwatch',
					'Snapfish' => 'snapfish',
					'Socket Set' => 'socket-set',
					'Socks' => 'socks',
					'Sofa' => 'sofa',
					'Software & Apps' => 'software-apps',
					'Sonicare' => 'sonicare',
					'Sonos' => 'sonos',
					'Sony' => 'sony',
					'Sony TV' => 'sony-tv',
					'Soundbar' => 'soundbar',
					'Soup Maker' => 'soup-maker',
					'Spa' => 'spa',
					'Spain' => 'spain',
					'Speakers' => 'speakers',
					'Spinner' => 'spinner',
					'Spirits' => 'spirits',
					'Splatoon' => 'splatoon',
					'Sports & Fitness' => 'sports-fitness',
					'SSD' => 'ssd',
					'Starbucks' => 'starbucks',
					'Star Trek' => 'star-trek',
					'Star Wars' => 'star-wars',
					'Steak' => 'steak',
					'Steam' => 'steam',
					'Steamer' => 'steamer',
					'Steam Iron' => 'steam-iron',
					'Steam Link' => 'steam-link',
					'Steam Mop' => 'steam-mop',
					'Storage' => 'storage',
					'Storage Box' => 'storage-box',
					'Strimmer' => 'strimmer',
					'Student' => 'student',
					'Suit' => 'suit',
					'Suitcase' => 'suitcase',
					'Sun Cream' => 'sun-cream',
					'Sunglasses' => 'sunglasses',
					'Superdry' => 'superdry',
					'Surface' => 'surface',
					'Surface Book' => 'surface-book',
					'Sweets' => 'sweets',
					'Swing' => 'swing',
					'Synology' => 'synology',
					'T-Shirt' => 't-shirt',
					'Table' => 'table',
					'Tablet' => 'tablet',
					'Table Tennis' => 'table-tennis',
					'Tado' => 'tado',
					'Tag Heuer' => 'tag-heuer',
					'Takeaway' => 'takeaway',
					'Talkmobile' => 'talkmobile',
					'Tap' => 'tap',
					'Tassimo' => 'tassimo',
					'Tastecard' => 'tastecard',
					'Tea' => 'tea',
					'Ted Baker' => 'ted-baker',
					'Tefal' => 'tefal',
					'Tekken' => 'tekken',
					'Tekken 7' => 'tekken-7',
					'Telegraph' => 'telegraph',
					'Telescope' => 'telescope',
					'Tenerife' => 'tenerife',
					'Tennis' => 'tennis',
					'Tent' => 'tent',
					'Tesco Clothing' => 'tesco-clothing',
					'Tesla' => 'tesla',
					'Thailand' => 'thailand',
					'Theatre' => 'theatre',
					'The Body Shop' => 'body-shop',
					'The Last Guardian' => 'the-last-guardian',
					'The Last Of Us' => 'the-last-of-us',
					'Theme Park' => 'theme-park',
					'Thermometer' => 'thermometer',
					'Thermos' => 'thermos',
					'Thermostat' => 'thermostat',
					'The Sun' => 'the-sun',
					'The Witcher 3' => 'the-witcher-3',
					'Thinkpad' => 'thinkpad',
					'Thomas Sabo' => 'thomas-sabo',
					'Thorntons' => 'thorntons',
					'Thorpe Park' => 'thorpe-park',
					'Throw' => 'throw',
					'Thrustmaster' => 'thrustmaster',
					'Thule' => 'thule',
					'Tights' => 'tights',
					'Tile' => 'tile',
					'Timberland' => 'timberland',
					'Tissot' => 'tissot',
					'Titanfall' => 'titanfall',
					'Titanfall 2' => 'titanfall-2',
					'Toaster' => 'toaster',
					'Toddler Bed' => 'toddler-bed',
					'Toilet' => 'toilet',
					'Toilet Roll' => 'toilet-roll',
					'Toilet Seat' => 'toilet-seat',
					'Tomb Raider' => 'tomb-raider',
					'Tom Clancy' => 'tom-clancy',
					'Tom Ford' => 'tom-ford',
					'Tommee Tippee' => 'tommee-tippee',
					'Toms' => 'toms',
					'TomTom' => 'tomtom',
					'Tool' => 'tool',
					'Toothbrush' => 'toothbrush',
					'Toothpaste' => 'toothpaste',
					'Toot Toot' => 'toot-toot',
					'Torch' => 'torch',
					'Torque Wrench' => 'torque-wrench',
					'Toshiba' => 'toshiba',
					'Towel' => 'towel',
					'Toyota' => 'toyota',
					'Toys' => 'toy',
					'Toy Story' => 'toy-story',
					'Tp Link' => 'tp-link',
					'Tracksuit' => 'tracksuit',
					'Train' => 'train',
					'Trainers' => 'trainers',
					'Trampoline' => 'trampoline',
					'Transcend' => 'transcend',
					'Transformers' => 'transformers',
					'Travel' => 'travel',
					'Travel Insurance' => 'travel-insurance',
					'Travelodge' => 'travelodge',
					'Travel System' => 'travel-system',
					'Treadmill' => 'treadmill',
					'Trespass' => 'trespass',
					'Trike' => 'trike',
					'Tripod' => 'tripod',
					'Tripp' => 'tripp',
					'Trolley' => 'trolley',
					'Trousers' => 'trousers',
					'Trunki' => 'trunki',
					'Tumble Dryer' => 'tumble-dryer',
					'Tuna' => 'tuna',
					'Turbo Trainer' => 'turbo-trainer',
					'Turkey' => 'turkey',
					'Turntable' => 'turntable',
					'Turtle Beach' => 'turtle-beach',
					'TV' => 'tv',
					'TV Stand' => 'tv-stand',
					'Tyres' => 'tyres',
					'Ubisoft' => 'ubisoft',
					'Ue Boom' => 'ue-boom',
					'UFC' => 'ufc',
					'UGG' => 'ugg',
					'Ulefone' => 'ulefone',
					'Ultimate Ears UE Boom 2' => 'ue-boom-2',
					'Ultimate Outdoors' => 'ultimate-outdoors',
					'Ultrabook' => 'ultrabook',
					'Ultrawide Monitor' => 'ultrawide',
					'Umbrella' => 'umbrella',
					'Umi' => 'umi',
					'Uncharted' => 'uncharted',
					'Uncharted 4' => 'uncharted-4',
					'Under Armour' => 'under-armour',
					'Underwear' => 'underwear',
					'Unicorn' => 'unicorn',
					'Unidays' => 'unidays',
					'Urban Decay' => 'urban-decay',
					'Usa' => 'usa',
					'USB Hub' => 'usb-hub',
					'USB Memory Stick' => 'flash-drive',
					'Usn' => 'usn',
					'Vacuum Cleaners' => 'vacuum-cleaners',
					'Vango' => 'vango',
					'Vanish' => 'vanish',
					'Vans' => 'vans',
					'Vape' => 'vape',
					'Vauxhall' => 'vauxhall',
					'Vax' => 'vax',
					'Velvet' => 'velvet',
					'Venice' => 'venice',
					'Versace' => 'versace',
					'Vibrator' => 'vibrator',
					'Victorinox' => 'victorinox',
					'Vileda' => 'vileda',
					'Vinyl' => 'vinyl',
					'Virgin' => 'virgin',
					'Vitamix' => 'vitamix',
					'Vodafone' => 'vodafone',
					'Vodka' => 'vodka',
					'Volvo' => 'volvo',
					'VPN' => 'vpn',
					'VR' => 'vr',
					'VTech' => 'vtech',
					'Vue' => 'vue',
					'VW' => 'vw',
					'Wacom' => 'wacom',
					'Waffle Maker' => 'waffle-maker',
					'Wahl' => 'wahl',
					'Walkers' => 'walkers',
					'Walking Boots' => 'walking-boots',
					'Walking Dead' => 'walking-dead',
					'Wallet' => 'wallet',
					'Wallpaper' => 'wallpaper',
					'Walsall' => 'walsall',
					'Wardrobe' => 'wardrobe',
					'Warhammer' => 'warhammer',
					'Washer Dryer' => 'washer-dryer',
					'Washing Machine' => 'washing-machine',
					'Watch' => 'watch',
					'Watch Dogs' => 'watch-dogs',
					'Watch Dogs 2' => 'watch-dogs-2',
					'Water Bottle' => 'water-bottle',
					'Water Butt' => 'water-butt',
					'Water Filter' => 'water-filter',
					'Wayfair' => 'wayfair',
					'Webcam' => 'webcam',
					'Weber' => 'weber',
					'Wedding' => 'wedding',
					'Weed' => 'weed',
					'Weekend Break' => 'weekend-break',
					'Weetabix' => 'weetabix',
					'Weight Watchers' => 'weight-watchers',
					'Wellies' => 'wellies',
					'Wenger' => 'wenger',
					'Western Digital' => 'western-digital',
					'Wetsuit' => 'wetsuit',
					'Wheelbarrow' => 'wheelbarrow',
					'Whey' => 'whey',
					'Whiskas' => 'whiskas',
					'Whisky' => 'whisky',
					'Wifi Camera' => 'wifi-camera',
					'Wifi Extender' => 'wifi-extender',
					'Wii' => 'wii',
					'Wii U' => 'wii-u',
					'Wii U Pro Controller' => 'wii-u-pro-controller',
					'Wileyfox' => 'wileyfox',
					'Wilkinson Sword' => 'wilkinson-sword',
					'Wimbledon' => 'wimbledon',
					'Windows' => 'windows',
					'Windows 10' => 'windows-10',
					'Wine' => 'wine',
					'Wipes' => 'wipes',
					'Wireless Headphones' => 'wireless-headphones',
					'Wireless Keyboard' => 'wireless-keyboard',
					'Witcher' => 'witcher',
					'Wok' => 'wok',
					'Wolfenstein' => 'wolfenstein',
					'Women Fashion' => 'womens-clothes',
					'Workbench' => 'workbench',
					'World Of Warcraft' => 'world-of-warcraft',
					'Worx' => 'worx',
					'Wuaki' => 'wuaki',
					'WWE' => 'wwe',
					'Xbox' => 'xbox',
					'Xbox 360' => 'xbox-360',
					'Xbox 360 Game' => 'xbox-360-game',
					'Xbox Controller' => 'xbox-controller',
					'Xbox Gift Card' => 'xbox-gift-card',
					'Xbox Headset' => 'xbox-headset',
					'Xbox Live' => 'xbox-live',
					'Xbox One' => 'xbox-one',
					'Xbox One Controller' => 'xbox-one-controller',
					'Xbox One Elite Controller' => 'xbox-one-elite-controller',
					'Xbox One Games' => 'xbox-one-games',
					'Xbox One S' => 'xbox-one-s',
					'Xbox One X' => 'xbox-one-x',
					'Xbox Wireless Adapter' => 'xbox-wireless-adapter',
					'Xcom' => 'xcom',
					'XCOM 2' => 'xcom-2',
					'XFX' => 'xfx',
					'Xiaomi' => 'xiaomi',
					'Xiaomi Redmi' => 'redmi',
					'Xperia' => 'xperia',
					'Xperia Z3' => 'xperia-z3',
					'Xperia Z5' => 'xperia-z5',
					'XPS' => 'xps',
					'Yakuza' => 'yakuza',
					'Yale' => 'yale',
					'Yamaha' => 'yamaha',
					'Yankee Candle' => 'yankee-candle',
					'Yoga' => 'yoga',
					'York' => 'york',
					'Yorkshire' => 'yorkshire',
					'Yoshi' => 'yoshi',
					'Youview' => 'youview',
					'Yves Saint Laurent' => 'yves-saint-laurent',
					'Zante' => 'zante',
					'Zanussi' => 'zanussi',
					'Zelda' => 'zelda',
					'Zelda Breath Of The Wild' => 'zelda-breath-of-the-wild',
					'Zenbook' => 'zenbook',
					'Zippo' => 'zippo',
					'Zizzi' => 'zizzi',
					'Zoo' => 'zoo',
					'Zoostorm' => 'zoostorm',
					'ZOTAC' => 'zotac',
					'ZTE' => 'zte',
					'ZyXEL' => 'zyxel',
				)
			),
			'order' => array(
				'name' => 'Order by',
				'type' => 'list',
				'required' => true,
				'title' => 'Sort order of deals',
				'values' => array(
					'From the most to the least hot deal' => '-hot',
					'From the most recent deal to the oldest' => '',
					'From the most commented deal to the least commented deal' => '-discussed'
				)
			)
		)
	);

	public $lang = array(
		'bridge-uri' => SELF::URI,
		'bridge-name' => SELF::NAME,
		'context-keyword' => 'Search by keyword(s))',
		'context-group' => 'Deals per group',
		'uri-group' => '/tag/',
		'request-error' => 'Could not request HotUKDeals',
		'no-results' => 'Ooops, looks like we could',
		'relative-date-indicator' => array(
			'ago',
		),
		'price' => 'Price',
		'shipping' => 'Shipping',
		'origin' => 'Origin',
		'discount' => 'Discount',
		'title-keyword' => 'Search',
		'title-group' => 'Group',
		'local-months' => array(
			'Jan',
			'Feb',
			'Mar',
			'Apr',
			'May',
			'Jun',
			'Jul',
			'Aug',
			'Sep',
			'Occ',
			'Nov',
			'Dec',
			'st',
			'nd',
			'rd',
			'th'
		),
		'local-time-relative' => array(
			'Found ',
			'm',
			'h,',
			'day',
			'days',
			'month',
			'year',
			'and '
		),
		'date-prefixes' => array(
			'Found ',
			'Refreshed ',
			'Made hot '
		),
		'relative-date-alt-prefixes' => array(
			'Made hot ',
			'Refreshed ',
			'Last updated '
		),
		'relative-date-ignore-suffix' => array(
			'/by.*$/'
		),
		'localdeal' => array(
			'Local',
			'Expires'
		)
	);

}
