#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/rc_types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  rsbac_rc_role_id_t role;
  char * progname;
  int verbose = 0;

  locale_init();

  progname = argv[0];
  if ((argc > 1) && (!strcmp("-v",argv[1])) )
    {
      verbose=1;
      argv++;
      argc--;
    }  
  if (argc >= 3)
    {
      role=strtol(argv[1],0,10);
      if(verbose)
        printf(gettext("%s: executing %s with role %i\n"),
               progname,argv[2],role);
      res = rsbac_rc_change_role(role);
      error_exit(res);
      res = execvp(argv[2],&argv[2]);
      error_exit(res);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s [-v] new_role prog args\n"), progname);
      printf(gettext("This program will set the process rc_role to new_role and then\n"));
      printf(gettext("execute prog via execvp()\n"));
      printf(gettext("-v = verbose\n"));
    }
  return (res);
}

