#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  int from_role, to_role;
  char * progname;
  
  progname = argv[0];
  if (argc == 3)
    {
      from_role=strtol(argv[1],0,10);
      to_role=strtol(argv[2],0,10);
      res = rsbac_rc_copy_role(from_role, to_role);
      error_exit(res);
    }
  else
    {
      printf("%s (RSBAC %s)\n***\n", argv[0], VERSION);
      printf("Use: %s from_role to_role\n", progname);
    }
  return (res);
}

