#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  rsbac_pm_task_id_t task;

  locale_init();

  if (argc >= 3)
    {
      task=strtol(argv[1],0,10);
      printf(gettext("%s: executing %s with task %i\n"), argv[0],argv[2],task);
      res = rsbac_pm_change_current_task(task);
      error_exit(res);
      res = execvp(argv[2],&argv[2]);
      error_exit(res);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s task-nr prog args\n"), argv[0]);
      printf(gettext("This program will set rsbac_pm_current_task to task-nr and then\n"));
      printf(gettext("execute prog via execvp()\n"));
    }
    
  return (res);
}

