#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  int j;
  rsbac_security_level_t seclevel;
  rsbac_mac_category_vector_t categories;
  char tmp[RSBAC_MAXNAMELEN];
  char * progname;
  int verbose = 0;
  int max = 0;
  int min = 0;
  int current = 0;
  int all = 1;

  locale_init();
  
  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'x':
                max=1;
                all=0;
                break;
              case 'n':
                min=1;
                all=0;
                break;
              case 'c':
                current=1;
                all=0;
                break;
              case 'a':
                all=1;
                break;
              default:
                printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
                printf(gettext("Use: %s [-v] [-c] [-x] [-n] [-a]\n"), progname);
                printf(gettext("This program will show the RSBAC MAC security levels\n"));
                printf(gettext("and category sets of the calling process.\n"));
                printf(gettext("-a = show all, -c = show current level and categories\n"));
                printf(gettext("-x = show max, -n = show min level and categories\n"));
                exit (1);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  if(current || all)
    {
      res = rsbac_mac_get_curr_level(&seclevel, &categories);
      error_exit(res);
      printf(gettext("Current level: %u\ncategories: %s\n"),
             seclevel,
             u64tostrmac(tmp, categories));
    }
  if(max || all)
    {
      res = rsbac_mac_get_max_level(&seclevel, &categories);
      error_exit(res);
      printf(gettext("Max level:     %u\ncategories: %s\n"),
             seclevel,
             u64tostrmac(tmp, categories));
    }
  if(min || all)
    {
      res = rsbac_mac_get_min_level(&seclevel, &categories);
      error_exit(res);
      printf(gettext("Min level:     %u\ncategories: %s\n"),
             seclevel,
             u64tostrmac(tmp, categories));
    }
  return 0;
}

