#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/aci_data_structures.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN],tmp3[RSBAC_MAXNAMELEN];
  char *key = (void *) 0;
  int i;
  int val;
  int id;
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  enum rsbac_target_t target;
  union rsbac_target_id_t tid;
  enum rsbac_attribute_t attr;
  struct passwd * user_info_p;
  char * progname = argv[0];
  int verbose = 0;
  rsbac_version_t version=RSBAC_VERSION_NR;

  locale_init();

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'a':
              case 'A':
                {
                  int u_attr_list[RSBAC_USER_NR_ATTRIBUTES] = RSBAC_USER_ATTR_LIST;
                  int p_attr_list[RSBAC_PROCESS_NR_ATTRIBUTES] = RSBAC_PROCESS_ATTR_LIST;

                  if(   (argc > 2)
                     && ((attr = get_attribute_nr(argv[2])) != A_none)
                    )
                    {
                      get_switch_target_name(tmp1, get_attr_module(attr));
                      get_attribute_name(tmp2, attr);
                      get_attribute_param(tmp3, attr);
                      printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                      exit(0);
                    }
                  printf(gettext("- attribute (string) and value (integer) = see following list:\n"));
                  printf("USER:\n");
                  for (i=0;i<RSBAC_USER_NR_ATTRIBUTES;i++)
                    {
                      get_switch_target_name(tmp1, get_attr_module(u_attr_list[i]));
                      get_attribute_name(tmp2,u_attr_list[i]);
                      get_attribute_param(tmp3,u_attr_list[i]);
                      printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    }
                  printf("\nPROCESS:\n");
                  for (i=0;i<RSBAC_PROCESS_NR_ATTRIBUTES;i++)
                    {
                      get_switch_target_name(tmp1, get_attr_module(p_attr_list[i]));
                      get_attribute_name(tmp2,p_attr_list[i]);
                      get_attribute_param(tmp3,p_attr_list[i]);
                      printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    }
                  exit(0);
                }
              case 'V':
                if(argc < 2)
                  {
                    fprintf(stderr, gettext("%s: no version number for switch V\n"), progname);
                    exit(1);
                  }
                version = strtol(argv[2],0,10);
                argv++;
                argc--;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  if (argc > 4)
    {
      printf(gettext("%s: %i targets\n\n"), progname, argc - 4);
      target = get_target_nr(argv[1]);
      if(   (target != T_PROCESS)
         && (target != T_USER))
        {
          fprintf(stderr, gettext("%s: Invalid Target %s!\n"), progname, argv[1]);
          exit(1);
        }
      attr = get_attribute_nr(argv[2]);
      if(attr == A_none)
        {
          fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), progname, argv[2]);
          exit(1);
        }
      val = strtol(argv[3],0,10);
      for (i=1;i < (argc-3);i++)
        {
          value.dummy = val;
          if (target == T_PROCESS)
            {
              id = strtol(argv[i+3],0,10);
              printf(gettext("Processing process %i, attribute %s (No. %i), value %i\n"), id, argv[2], attr, val);
              tid.process = id;
            }
          else
            {
              if(   (!(user_info_p = getpwnam(argv[i+3])))
                 && (!(user_info_p = getpwuid(strtol(argv[i+3],0,10)))) )
                {
                  fprintf(stderr, "Invalid user %s!\n\n", argv[i+3]);
                  continue;
                }
              printf(gettext("Processing user %s (uid %i), attribute %s (No. %i), value %i\n"),
                     user_info_p->pw_name, user_info_p->pw_uid, argv[2], attr, val);
              tid.user = user_info_p->pw_uid;
            }
          res = rsbac_set_attr(module, target, &tid, attr, &value);
          error_exit(res);
        }
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [switches] module target-type attribute value user/proc-nr.\n\n"), progname);  
      printf(gettext("- module = GEN, MAC, FC, SIM, PM, MS, FF, RC or AUTH\n"));
      printf(gettext("- target-type = USER or PROCESS\n"));
      printf(gettext("  -V version = supply RSBAC integer version number for upgrading\n"));
    }
  return (res);
}
