#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int attr_list[RSBAC_USER_NR_ATTRIBUTES] = RSBAC_USER_ATTR_LIST;
  int res = 0;
  u_int position;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN],tmp3[RSBAC_MAXNAMELEN];
  int j;
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  union rsbac_target_id_t tid;
  enum rsbac_attribute_t attr;
  struct passwd * user_info_p;
  int inherit = 0;
  int numeric = 0;
  int both = 0;
  int printall = 0;
  int scripting = 0;
  char * progname = argv[0];
  boolean use_ori = FALSE;

  locale_init();

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'e':
                inherit=1;
                break;
              case 'p':
                printall=1;
                break;
              case 'n':
                numeric=1;
                break;
              case 'b':
                both=1;
                break;
              case 's':
                scripting=1;
                break;
              case 'l':
                while((user_info_p = getpwent()))
                  {
                    if(numeric)
                      printf("%u\n", user_info_p->pw_uid);
                    else
                    if(both)
                      printf("%s %u\n", user_info_p->pw_name, user_info_p->pw_uid);
                    else
                      printf("%s\n", user_info_p->pw_name);
                  }
                exit(0);
              case 'u':
                if(argc > 2)
                  {
                    rsbac_uid_t uid;

                    if((user_info_p = getpwnam(argv[2])))
                      {
                        printf("%u\n", user_info_p->pw_uid);
                        exit(0);
                      }
                    else
                      {
                        uid = strtoul(argv[2],0,10);
                        if(   (   uid
                               || !strcmp("0", argv[2])
                              )
                           && (user_info_p = getpwuid(uid))
                          )
                          {
                            printf("%u\n", user_info_p->pw_uid);
                            exit(0);
                          }
                        else
                          {
                            fprintf(stderr, "Wrong argument %s to parameter u!\n", argv[2]);
                            exit(1);
                          }
                      }
                  }
                else
                  {
                    fprintf(stderr, "Missing argument to parameter u!\n");
                    exit(1);
                  }
              case 'c':
                {
                  char tmp[RSBAC_MAXNAMELEN];
                  int i;

                  for(i=0; i<CAP_NONE; i++)
                    printf("%s\n", get_cap_name(tmp, i));
                  exit(0);
                }
              case 'R':
                {
                  char tmp[RSBAC_MAXNAMELEN];
                  int i;

                  for(i=0; i<=RSBAC_RES_MAX; i++)
                    printf("%s\n", get_res_name(tmp, i));
                  exit(0);
                }
              case 'a':
              case 'A':
                if(   (argc > 2)
                   && ((attr = get_attribute_nr(argv[2])) != A_none)
                  )
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr));
                    get_attribute_name(tmp2, attr);
                    get_attribute_param(tmp3, attr);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    exit(0);
                  }
                printf(gettext("- attribute (string) and returned value = see following list:\n"));
                for (j=0;j<RSBAC_USER_NR_ATTRIBUTES;j++)
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr_list[j]));
                    get_attribute_name(tmp2,attr_list[j]);
                    get_attribute_param(tmp3,attr_list[j]);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                  }
                printf(gettext("[RES ] res_min|res_max (with additional parameter position)\n\tnon-negative integer (0 for unset)\n"));
                exit(0);

              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  switch(argc)
    {
      case 3:
        value.dummy = -1;
        if(   (!(user_info_p = getpwnam(argv[1])))
           && (   (!(user_info_p = getpwuid(strtoul(argv[1],0,10))))
               || (!(user_info_p->pw_uid) && strcmp("0",argv[1])) )
          )
            {
              use_ori = TRUE;
              tid.user = strtoul(argv[1],0,10);
            }
        else
          tid.user = user_info_p->pw_uid;
        if(!strcmp("user_nr",argv[2]))
          {
            if(use_ori)
              printf("%s\n", argv[1]);
            else
              printf("%i\n", user_info_p->pw_uid);
            exit(0);
          }
        if(!strcmp("user_name",argv[2]))
          {
            if(use_ori)
              printf("%s\n", argv[1]);
            else
              printf("%s\n", user_info_p->pw_name);
            exit(0);
          }
        if(!strcmp("full_name",argv[2]))
          {
            if(use_ori)
              printf("%s\n", argv[1]);
            else
              printf("%s\n", user_info_p->pw_gecos);
            exit(0);
          }

        attr = get_attribute_nr(argv[2]);
        if(attr == A_none)
          {
            fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), progname, argv[2]);
            exit(1);
          }

        res = rsbac_get_attr(module, T_USER, &tid, attr, &value, inherit);
        error_exit(res);
        switch(attr)
          {
            case A_mac_role:
            case A_mac_user_flags:
            case A_fc_role:
            case A_sim_role:
            case A_pm_role:
            case A_ms_role:
            case A_ff_role:
            case A_auth_role:
            case A_cap_role:
            case A_jail_role:
            case A_res_role:
            case A_security_level:
            case A_initial_security_level:
            case A_min_security_level:
              printf("%u\n",value.u_char_dummy);
              break;
            case A_rc_type:
            case A_rc_type_fd:
            case A_rc_force_role:
            case A_rc_role:
            case A_rc_def_role:
              printf("%u\n",value.rc_role);
              break;
            case A_mac_categories:
            case A_mac_initial_categories:
            case A_mac_min_categories:
              printf("%s\n",u64tostrmac(tmp1,value.mac_categories));
              break;
            case A_log_user_based:
              if(printall)
                {
                  int i;

                  for (i=0; i<R_NONE; i++)
                    if(value.log_user_based & ((rsbac_request_vector_t) 1 << i))
                      printf(" %s\n", get_request_name(tmp1,i));
                }
              else
                printf("%s\n",u64tostrlog(tmp1,value.log_user_based));
              break;
            case A_min_caps:
            case A_max_caps:
              if(printall)
                {
                  int i;

                  for (i=0; i<CAP_NONE; i++)
                    if(value.min_caps & ((rsbac_cap_vector_t) 1 << i))
                      printf(" %s\n", get_cap_name(tmp1,i));
                }
              else
                printf("%s\n",u32tostrcap(tmp1,value.min_caps));
              break;
            case A_res_min:
            case A_res_max:
                {
                  int i;

                  if(scripting)
                    {
                      for (i=0; i<=RSBAC_RES_MAX; i++)
                        printf("%u ", value.res_array[i]);
                      printf("\n");
                    }
                  else
                    for (i=0; i<=RSBAC_RES_MAX; i++)
                      printf("%s\t%u\n", get_res_name(tmp1,i), value.res_array[i]);
                }
              break;
            default:
              printf("%i\n",value.dummy);
          }
        exit(0);

      case 4:
        attr = get_attribute_nr(argv[2]);
        if(   (!(user_info_p = getpwnam(argv[1])))
           && (   (!(user_info_p = getpwuid(strtoul(argv[1],0,10))))
               || (!(user_info_p->pw_uid) && strcmp("0",argv[1])) )
          )
            {
              tid.user = strtoul(argv[1],0,10);
            }
        else
          tid.user = user_info_p->pw_uid;
        switch(attr)
          {
            case A_mac_categories:
            case A_mac_initial_categories:
            case A_mac_min_categories:
              position = strtoul(argv[3],0,10);
              if(position > RSBAC_MAC_MAX_CAT)
                {
                  fprintf(stderr, gettext("Invalid position counter %s\n"), argv[3]);
                  exit(1);
                }
              res = rsbac_get_attr(module, T_USER, &tid, attr, &value, inherit);
              error_exit(res);
              printf("%u\n",
                     (u_int) (value.mac_categories >> position) & 1);
              exit(0);

            case A_log_user_based:
              position = get_request_nr(argv[3]);
              if(position >= R_NONE)
                {
                  fprintf(stderr, gettext("Invalid request %s\n"), argv[3]);
                  exit(1);
                  }
                res = rsbac_get_attr(module, T_USER, &tid, A_log_user_based, &value, inherit);
                error_exit(res);
                printf("%u\n",
                     (u_int) (value.log_program_based >> position) & 1);
                exit(0);

            case A_res_min:
            case A_res_max:
              position = get_res_nr(argv[3]);
              if(position == RSBAC_RES_NONE)
                {
                  position = strtoul(argv[3],0,10);
                  if(   (!position && strcmp(argv[3], "0"))
                     || (position > RSBAC_RES_MAX)
                    )
                    {
                      fprintf(stderr, gettext("Invalid position counter %s\n"), argv[3]);
                      exit(1);
                    }
                }
              res = rsbac_get_attr(module, T_USER, &tid, attr, &value, FALSE);
              error_exit(res);
              printf("%u\n",
                     value.res_array[position]);
              exit(0);

            default:
              break;
          }

      default:
        printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
        printf(gettext("Use: %s [switches] module user attribute [position|request-name]\n\n"), progname);  
        printf(gettext("- -e = show effective (maybe inherited) value, not real\n"));
        printf(gettext("- -n = numeric value, -b = both names and numbers, -l list all users\n"));
        printf(gettext("- -c list all Linux capabilities, -R = list all RES resource names\n"));
        printf(gettext("- -a = list attributes and values\n"));
        printf(gettext("- module = GEN, MAC, FC, SIM, PM, MS, FF, RC or AUTH\n"));
        printf(gettext("mac_[min_]categories\t\t(with additional parameter position)\n\t\t\t0=no, 1=yes\n"));
        printf(gettext("log_user_based\t(with additional parameter request-name)\n\t\t\t0=no, 1=yes\n"));
    }
  exit(1);
}
