#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <pwd.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  char * progname = argv[0];
  int allyes = 0;

  locale_init();
  
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'y':
                allyes=1;
                break;

              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  if (argc > 1)
    {
      struct passwd * user_info_p;
      struct rsbac_acl_syscall_arg_t   arg;
      char            yn;

      if(   (!(user_info_p = getpwnam(argv[1])))
         && (   (!(user_info_p = getpwuid(strtol(argv[1],0,10))))
             || (!(user_info_p->pw_uid) && strcmp("0",argv[1])) )
            )
        {
          fprintf(stderr, gettext("Invalid user %s!\n"), argv[1]);
          exit(1);
        }
      arg.target = T_USER;
      arg.tid.user = user_info_p->pw_uid;
      arg.subj_type = ACLS_USER;
      arg.subj_id = user_info_p->pw_uid;
      if(!allyes)
        {
          printf(gettext("Remove all groups and memberships of user %u '%s' [y/n]\n"),
                 user_info_p->pw_uid,
                 user_info_p->pw_name);
          yn = getchar();
          if(yn != 'y')
            exit(0);
        }
      res = rsbac_acl(ACLC_remove_user, &arg);
      error_exit(res);
      exit(0);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Remove all groups and memberships of a user\n\n"));  
      printf(gettext("Use: %s [-y] user\n"), progname);  
      printf(gettext(" -y: remove without asking\n"));  
      exit(1);
    }
}

