/* parser.y - configuration file parser, bison. */
/*
 *  RRDcollect  --  Round-Robin Database Collecting Daemon.
 *  Copyright (C) 2003  Dawid Kuroczko <qnex@knm.org.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

%{
#include "rrdcollect.h"

/* scanner.l */
extern int yylineno;

/* local functions */
inline void yyerror(const char *s);

#ifndef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#endif /* YYERROR_VERBOSE */

%}

%union {
	int         val;
	const char *str;
}

%token <str> URI_FILE
%token <str> URI_EXEC
%token <str> URI_HTTP
%token <str> URI_PIPE
%token <str> URI_SNMP
%token <str> URI_NETLINK
%token <str> URI_ULOG
%token <str> URI_PCAP
%token <str> URI_PING
%token <str> URI_RRD

%token <str> NAME
%token <val> NUMBER
%token <str> PATH
%token <str> HOST

%token <str> STRING
%token <str> REGEX

%token <str> RRDFILE
%token <str> DSNAME
%token <str> DSCREATE

%%

input:	  nlfs constants tests
	| error '\n'			{ /* yyerrok; */ };

/* line feeds */
nlfs:	|
	  lfs
;
lfs:	  '\n'
	| lfs lfs
;

constants: constant lfs
	| constants constants
;

tests:	uri lfs matches nlfs
	| tests tests
;

/* definitions */
constant: NAME '=' STRING		{ printf("var %s = \"%s\"\n", $1, $3); }
	| NAME '=' PATH			{ printf("var %s = \"%s\"\n", $1, $3); }
	| NAME '=' NUMBER		{ printf("var %s = %d\n", $1, $3); }
;

/* uri part */
uri:	  uri_file
	| uri_exec
	| uri_http
	| uri_rrd
;

uri_file: URI_FILE ':' '/' '/' PATH	{ printf("\nuri file = %s\n", $5); }
	| URI_FILE ':' PATH		{ printf("\nuri file = %s\n", $3); }
;

uri_exec: URI_EXEC ':' '/' '/' PATH	{ printf("\nuri exec = %s\n", $5); }
	| URI_EXEC ':' PATH		{ printf("\nuri exec = %s\n", $3); }
	| URI_EXEC ':' STRING		{ printf("\nuri exec = \"%s\"\n", $3); }
;

uri_http: URI_HTTP hostspec PATH	{ }
;

uri_rrd:  URI_RRD hostspec '/'		{ }
;

hostspec: ':' '/' '/' NAME ':' NAME '@' HOST ':' NUMBER
	| ':' '/' '/' NAME ':' NAME '@' HOST
	| ':' '/' '/' NAME '@' HOST ':' NUMBER
	| ':' '/' '/' NAME '@' HOST 
	| ':' '/' '/' HOST ':' NUMBER
	| ':' '/' '/' HOST
;

/* matches */
matches:  match targets lfs
	| match variables lfs
	| match variables targets lfs
	| matches matches
;

match:	  match submatches
	|  pattern
	| REGEX				{ printf("match = /%s/\n", $1); }
;

submatches: '+' pattern
;

pattern:  STRING			{ printf("match = \"%s\"\n", $1); }
	| NUMBER ':' STRING		{ printf("lineno = %d, match = \"%s\"\n", $1, $3); }
;

/* variables */
variables:NAME '=' '$' NUMBER dsmod	{ printf("assign %s = $%d\n", $1, $4); }
	| DSNAME '=' '$' NUMBER dsmod	{ printf("assign %s = $%d\n", $1, $4); }
	| variables variables
;
/* RRD */
targets:  rrd
;
	
rrd:	  RRDFILE ':' ds_list		{ printf("rrdfile = %s\n", $1); }
;
ds_list:  ds
	| ds_list ',' ds_list
;

ds:	  DSNAME dscreate dsmod		{ printf("ds %s ", $1); }
	| DSNAME dscreate '=' '$' NAME dsmod	{ printf("ds %s=$%s ", $1, $5); }
	| DSNAME dscreate '=' '$' dsmod	{ printf("ds %s=$%s ", $1, $1); }
;

dscreate:
	| '(' DSCREATE ')'		{ printf("DSCREATE(%s)\n", $2); }
;

dsmod:
	| '*' NUMBER
	| '/' NUMBER
	| '+' NUMBER
	| '-' NUMBER
;

%%

int store_urihost(
	__attribute__ ((unused)) const char *user,
	__attribute__ ((unused)) const char *pass,
	__attribute__ ((unused)) const char *host,
	__attribute__ ((unused)) const int port)
{
	return 0;
}

int store_constant(__attribute__ ((unused)) const char *name, __attribute__ ((unused)) const char *value)
{
	return 0;
}

inline void yyerror(const char *s)
{
	printf("ERROR at line %d: %s\n", yylineno, s);
}

int parse_config_file(__attribute__ ((unused)) const char *file)
{
	return yyparse();
}


#ifdef STANDALONE_PARSER
int main()
{
	return yyparse();
}
#endif /* STANDALONE_PARSER */

