<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="keywords" content="openstreetmap routino verifier">
<meta name="viewport" content="width=device-width, height=device-height, initial-scale=1, user-scalable=no">

<title>Routino : Data Visualiser for Routing Data</title>

<!--
Routino data visualiser web page.

Part of the Routino routing software.

This file Copyright 2008-2014 Andrew M. Bishop

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see http://www.gnu.org/licenses/.
-->

<!-- Page elements -->
<script src="page-elements.js" type="text/javascript"></script>
<link href="page-elements.css" type="text/css" rel="stylesheet">

<!-- Router and visualiser shared features -->
<link href="maplayout.css" type="text/css" rel="stylesheet">

<!-- Visualiser specific features -->
<script src="mapprops.js" type="text/javascript"></script>
<link href="visualiser.css" type="text/css" rel="stylesheet">

<!-- Map parameters -->
<script src="mapprops.js" type="text/javascript"></script>

<!-- Map loader -->
<script src="maploader.js" type="text/javascript"></script>

</head>
<body onload="map_load('map_init();');">

<!-- Left hand side of window - data panel -->

<div class="left_panel">

<div class="tab_box">
<span id="tab_visualiser" onclick="tab_select('visualiser');" class="tab_selected" title="Select data options">Visualiser</span>
<span id="tab_router" onclick="tab_select('router');" class="tab_unselected" title="Plan a route">Router</span>
<span id="tab_data" onclick="tab_select('data');" class="tab_unselected" title="View database information">Data</span>
</div>

<div class="tab_content" id="tab_visualiser_div">

<div class="hideshow_box">
<span class="hideshow_title">Routino Visualiser</span>
This web page allows visualisation of the data that Routino uses for routing.
Only data relevant for routing is displayed and some will therefore be excluded.
<div class="center">
<a target="other" href="http://www.routino.org/">Routino Website</a>
|
<a target="other" href="documentation/">Документация</a>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_language_show" onclick="hideshow_show('language');" class="hideshow_show">+</span>
<span id="hideshow_language_hide" onclick="hideshow_hide('language');" class="hideshow_hide">-</span>
<span class="hideshow_title">Язык</span>

<div id="hideshow_language_div" style="display: none;">
<table>
<tr>
<td><a id="lang_en_url" href="visualiser.html.en" title="English language webpage">English</a>
<td>(EN)
<tr>
<td><a id="lang_de_url" href="visualiser.html.de" title="Deutsche Webseite">Deutsch</a>
<td>(DE)
<tr>
<td><a id="lang_fr_url" href="visualiser.html.fr" title="Page web en français">Français</a>
<td>(FR)
<tr>
<td><a id="lang_hu_url" href="visualiser.html.hu" title="Magyar weblap">Magyar</a>
<td>(HU)
<tr>
<td><a id="lang_nl_url" href="visualiser.html.nl" title="Nederlandse web pagina">Nederlands</a>
<td>(NL)
<tr>
<td><a id="lang_pl_url" href="visualiser.html.pl" title="Polski webpage">Polski</a>
<td>(PL)
<tr>
<td><a id="lang_ru_url" href="visualiser.html.ru" title="Русский">Русский</a>
<td>(RU)
</table>
<a target="translation" href="http://www.routino.org/translations/">Routino Translations</a>
</div>
</div>

<div class="hideshow_box">
<span class="hideshow_title">Инструкции</span>
Zoom in and then use the buttons below to download the data. The
server will only return data if the selected area is small enough.
</div>

<div class="hideshow_box">
<span class="hideshow_title">Статус</span>
<div id="result_status">
<div id="result_status_no_data">
<b><i>Нет данных для отображения</i></b>
</div>
<div id="result_status_data" style="display: none;">
</div>
<div id="result_status_failed" style="display: none;">
<b>Failed to get visualiser data!</b>
</div>
<div id="result_status_junctions" style="display: none;">
<b>Processed # junctions</b>
</div>
<div id="result_status_super" style="display: none;">
<b>Processed # super-nodes/segments</b>
</div>
<div id="result_status_waytype" style="display: none;">
<b>Processed # way type segments</b>
</div>
<div id="result_status_highway" style="display: none;">
<b>Processed # segments</b>
</div>
<div id="result_status_transport" style="display: none;">
<b>Processed # segments</b>
</div>
<div id="result_status_barrier" style="display: none;">
<b>Обработано # нод</b>
</div>
<div id="result_status_turns" style="display: none;">
<b>Обработано # ограничений поворотов</b>
</div>
<div id="result_status_limit" style="display: none;">
<b>Processed # limit changes</b>
</div>
<div id="result_status_property" style="display: none;">
<b>Processed # segments</b>
</div>
<div id="result_status_errorlogs" style="display: none;">
<b>Processed # error logs</b>
</div>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_junctions_show" onclick="hideshow_show('junctions');" class="hideshow_show">+</span>
<span id="hideshow_junctions_hide" onclick="hideshow_hide('junctions');" class="hideshow_hide">-</span>
<input type="button" id="junctions" onclick="displayData('junctions');" value="Display Junctions">
<div id="hideshow_junctions_div" style="display: none;">
Each node that is a dead-end, a junction of two highways of different
types (or different properties) or a junction where more than two segments
join are shown colour-coded.
<br>
<table>
<tr><td><img src="icons/ball-1.png" alt="1" ><td>only one highway - a dead-end.
<tr><td><img src="icons/ball-2.png" alt="2" ><td>two highways of different types meet.
<tr><td><img src="icons/ball-3.png" alt="3" ><td>three highways meet.
<tr><td><img src="icons/ball-4.png" alt="4" ><td>four highways meet.
<tr><td><img src="icons/ball-5.png" alt="5" ><td>five highways meet.
<tr><td><img src="icons/ball-6.png" alt="6" ><td>six highways meet.
<tr><td><img src="icons/ball-7.png" alt="7+"><td>seven (or more) highways meet.
</table>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_super_show" onclick="hideshow_show('super');" class="hideshow_show">+</span>
<span id="hideshow_super_hide" onclick="hideshow_hide('super');" class="hideshow_hide">-</span>
<input type="button" id="super" onclick="displayData('super');" value="Display Super Segments">
<div id="hideshow_super_div" style="display: none;">
Each super-node and the associated super-segments are shown (see
algorithm page for description).
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_waytype_show" onclick="hideshow_show('waytype');" class="hideshow_show">+</span>
<span id="hideshow_waytype_hide" onclick="hideshow_hide('waytype');" class="hideshow_hide">-</span>
<input type="button" id="waytype" onclick="displayData('waytype');" value="Display Way Type Segments">
<div id="hideshow_waytype_div" style="display: none;">
Each highway segment of special types (one-way, cycle-both-ways and roundabout) are
shown. For one-way segments a coloured triangle indicates the allowed direction.
The colours of the triangles depend on the bearing of the highway segment.
<form name="waytypes" id="waytypes" action="#" method="get" onsubmit="return false;">
<table>
<tr><td>One-way segments: <td><input name="waytype" type="radio" value="oneway" onchange="displayData('waytype');" checked>
<tr><td>Cycle-both-way segments:<td><input name="waytype" type="radio" value="cyclebothways" onchange="displayData('waytype');">
<tr><td>Roundabout segments: <td><input name="waytype" type="radio" value="roundabout" onchange="displayData('waytype');">
</table>
</form>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_highway_show" onclick="hideshow_show('highway');" class="hideshow_show">+</span>
<span id="hideshow_highway_hide" onclick="hideshow_hide('highway');" class="hideshow_hide">-</span>
<input type="button" id="highway" onclick="displayData('highway');" value="Display Highway Segments">
<div id="hideshow_highway_div" style="display: none;">
Each segment of the chosen type of highway is drawn.
<form name="highways" id="highways" action="#" method="get" onsubmit="return false;">
<table>
<tr><td>Автомагистраль: <td><input name="highway" type="radio" value="motorway" onchange="displayData('highway');">
<tr><td>Trunk: <td><input name="highway" type="radio" value="trunk" onchange="displayData('highway');">
<tr><td>Primary: <td><input name="highway" type="radio" value="primary" onchange="displayData('highway');" checked>
<tr><td>Secondary: <td><input name="highway" type="radio" value="secondary" onchange="displayData('highway');">
<tr><td>Tertiary: <td><input name="highway" type="radio" value="tertiary" onchange="displayData('highway');">
<tr><td>Unclassified:<td><input name="highway" type="radio" value="unclassified" onchange="displayData('highway');">
<tr><td>Residential: <td><input name="highway" type="radio" value="residential" onchange="displayData('highway');">
<tr><td>Service: <td><input name="highway" type="radio" value="service" onchange="displayData('highway');">
<tr><td>Track: <td><input name="highway" type="radio" value="track" onchange="displayData('highway');">
<tr><td>Cycleway: <td><input name="highway" type="radio" value="cycleway" onchange="displayData('highway');">
<tr><td>Path: <td><input name="highway" type="radio" value="path" onchange="displayData('highway');">
<tr><td>Steps: <td><input name="highway" type="radio" value="steps" onchange="displayData('highway');">
<tr><td>Ferry: <td><input name="highway" type="radio" value="ferry" onchange="displayData('highway');">
</table>
</form>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_transport_show" onclick="hideshow_show('transport');" class="hideshow_show">+</span>
<span id="hideshow_transport_hide" onclick="hideshow_hide('transport');" class="hideshow_hide">-</span>
<input type="button" id="transport" onclick="displayData('transport');" value="Display Transport Segments">
<div id="hideshow_transport_div" style="display: none;">
Each segment allowed for the chosen type of transport is drawn.
<form name="transports" id="transports" action="#" method="get" onsubmit="return false;">
<table>
<tr><td>Foot: <td><input name="transport" type="radio" value="foot" onchange="displayData('transport');">
<tr><td>Лошадь: <td><input name="transport" type="radio" value="horse" onchange="displayData('transport');">
<tr><td>Инвалидное кресло:<td><input name="transport" type="radio" value="wheelchair" onchange="displayData('transport');">
<tr><td>Велосипед: <td><input name="transport" type="radio" value="bicycle" onchange="displayData('transport');">
<tr><td>Мопед: <td><input name="transport" type="radio" value="moped" onchange="displayData('transport');">
<tr><td>Мотоцикл:<td><input name="transport" type="radio" value="motorcycle" onchange="displayData('transport');">
<tr><td>Motorcar: <td><input name="transport" type="radio" value="motorcar" onchange="displayData('transport');" checked>
<tr><td>Товары: <td><input name="transport" type="radio" value="goods" onchange="displayData('transport');">
<tr><td>HGV: <td><input name="transport" type="radio" value="hgv" onchange="displayData('transport');">
<tr><td>PSV: <td><input name="transport" type="radio" value="psv" onchange="displayData('transport');">
</table>
</form>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_barrier_show" onclick="hideshow_show('barrier');" class="hideshow_show">+</span>
<span id="hideshow_barrier_hide" onclick="hideshow_hide('barrier');" class="hideshow_hide">-</span>
<input type="button" id="barrier" onclick="displayData('barrier');" value="Display Barrier Nodes">
<div id="hideshow_barrier_div" style="display: none;">
Each barrier blocking the chosen type of transport is drawn.
<form name="barriers" id="barriers" action="#" method="get" onsubmit="return false;">
<table>
<tr><td>Foot: <td><input name="barrier" type="radio" value="foot" onchange="displayData('barrier');">
<tr><td>Лошадь: <td><input name="barrier" type="radio" value="horse" onchange="displayData('barrier');">
<tr><td>Инвалидное кресло:<td><input name="barrier" type="radio" value="wheelchair" onchange="displayData('barrier');">
<tr><td>Велосипед: <td><input name="barrier" type="radio" value="bicycle" onchange="displayData('barrier');">
<tr><td>Мопед: <td><input name="barrier" type="radio" value="moped" onchange="displayData('barrier');">
<tr><td>Мотоцикл:<td><input name="barrier" type="radio" value="motorcycle" onchange="displayData('barrier');">
<tr><td>Motorcar: <td><input name="barrier" type="radio" value="motorcar" onchange="displayData('barrier');" checked>
<tr><td>Товары: <td><input name="barrier" type="radio" value="goods" onchange="displayData('barrier');">
<tr><td>HGV: <td><input name="barrier" type="radio" value="hgv" onchange="displayData('barrier');">
<tr><td>PSV: <td><input name="barrier" type="radio" value="psv" onchange="displayData('barrier');">
</table>
</form>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_turns_show" onclick="hideshow_show('turns');" class="hideshow_show">+</span>
<span id="hideshow_turns_hide" onclick="hideshow_hide('turns');" class="hideshow_hide">-</span>
<input type="button" id="turns" onclick="displayData('turns');" value="Показывать ограничения поворотов">
<div id="hideshow_turns_div" style="display: none;">
Each turn restrictions is shown with a line indicating the disallowed turn.
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_speed_show" onclick="hideshow_show('speed');" class="hideshow_show">+</span>
<span id="hideshow_speed_hide" onclick="hideshow_hide('speed');" class="hideshow_hide">-</span>
<input type="button" id="speed" onclick="displayData('speed');" value="Показывать ограничения скорости">
<div id="hideshow_speed_div" style="display: none;">
Each node that joins segments with different speed limits is shown
along with the speed limit on relevant segments.
<br>
<table>
<tr><td><img src="icons/ball-1.png" alt="." ><td>Изменить ограничения
<tr><td><img src="icons/limit-no.png" alt="()" ><td>No specified limit
<tr><td><img src="icons/limit-80.png" alt="(80)"><td>Ограничение скорости 80 км/ч
</table>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_weight_show" onclick="hideshow_show('weight');" class="hideshow_show">+</span>
<span id="hideshow_weight_hide" onclick="hideshow_hide('weight');" class="hideshow_hide">-</span>
<input type="button" id="weight" onclick="displayData('weight');" value="Показывать ограничения по весу">
<div id="hideshow_weight_div" style="display: none;">
Each node that joins segments with different weight limits is shown
along with the weight limit on relevant segments.
<br>
<table>
<tr><td><img src="icons/ball-1.png" alt="." ><td>Изменить ограничения
<tr><td><img src="icons/limit-no.png" alt="()" ><td>No specified limit
<tr><td><img src="icons/limit-8.0.png" alt="(8.0)"><td>Ограничение веса 8 тонн
</table>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_height_show" onclick="hideshow_show('height');" class="hideshow_show">+</span>
<span id="hideshow_height_hide" onclick="hideshow_hide('height');" class="hideshow_hide">-</span>
<input type="button" id="height" onclick="displayData('height');" value="Показывать ограничение по высоте">
<div id="hideshow_height_div" style="display: none;">
Each node that joins segments with different height limits is shown
along with the height limit on relevant segments.
<br>
<table>
<tr><td><img src="icons/ball-1.png" alt="." ><td>Изменить ограничения
<tr><td><img src="icons/limit-no.png" alt="()" ><td>No specified limit
<tr><td><img src="icons/limit-4.0.png" alt="(4.0)"><td>Ограничение высоты 4.0 метра
</table>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_width_show" onclick="hideshow_show('width');" class="hideshow_show">+</span>
<span id="hideshow_width_hide" onclick="hideshow_hide('width');" class="hideshow_hide">-</span>
<input type="button" id="width" onclick="displayData('width');" value="Показывать ограничение ширины">
<div id="hideshow_width_div" style="display: none;">
Each node that joins segments with different width limits is shown
along with the width limit on relevant segments.
<br>
<table>
<tr><td><img src="icons/ball-1.png" alt="." ><td>Изменить ограничения
<tr><td><img src="icons/limit-no.png" alt="()" ><td>No specified limit
<tr><td><img src="icons/limit-3.0.png" alt="(3.0)"><td>3.0 m width limit
</table>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_length_show" onclick="hideshow_show('length');" class="hideshow_show">+</span>
<span id="hideshow_length_hide" onclick="hideshow_hide('length');" class="hideshow_hide">-</span>
<input type="button" id="length" onclick="displayData('length');" value="Display Length Limits">
<div id="hideshow_length_div" style="display: none;">
Each node that joins segments with different length limits is shown
along with the length limit on relevant segments.
<br>
<table>
<tr><td><img src="icons/ball-1.png" alt="." ><td>Изменить ограничения
<tr><td><img src="icons/limit-no.png" alt="()" ><td>No specified limit
<tr><td><img src="icons/limit-9.0.png" alt="(9.0)"><td>9.0 m length limit
</table>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_property_show" onclick="hideshow_show('property');" class="hideshow_show">+</span>
<span id="hideshow_property_hide" onclick="hideshow_hide('property');" class="hideshow_hide">-</span>
<input type="button" id="property" onclick="displayData('property');" value="Display Highway Properties">
<div id="hideshow_property_div" style="display: none;">
Each segment of the highways with a particular property is drawn.
<form name="properties" id="properties" action="#" method="get" onsubmit="return false;">
<table>
<tr><td>Paved: <td><input name="property" type="radio" value="paved" onchange="displayData('property');" checked>
<tr><td>Multiple Lanes: <td><input name="property" type="radio" value="multilane" onchange="displayData('property');">
<tr><td>Мост: <td><input name="property" type="radio" value="bridge" onchange="displayData('property');">
<tr><td>Туннель: <td><input name="property" type="radio" value="tunnel" onchange="displayData('property');">
<tr><td>Пеший маршрут: <td><input name="property" type="radio" value="footroute" onchange="displayData('property');">
<tr><td>Велодорожка: <td><input name="property" type="radio" value="bicycleroute" onchange="displayData('property');">
</table>
</form>
</div>
</div>

<div class="hideshow_box">
<span id="hideshow_errorlogs_show" onclick="hideshow_show('errorlogs');" class="hideshow_show">+</span>
<span id="hideshow_errorlogs_hide" onclick="hideshow_hide('errorlogs');" class="hideshow_hide">-</span>
<input type="button" id="errorlogs" onclick="displayData('errorlogs');" value="Display Error Logs">
<div id="hideshow_errorlogs_div" style="display: none;">
Potential problems found by Routino when processing the input data.
</div>
</div>

<div class="hideshow_box">
<input type="button" id="clear" onclick="displayData('');" value="Clear data">
</div>

<div class="hideshow_box">
<span class="hideshow_title">Links</span>
<a id="permalink_url" href="visualiser.html">Link to this map view</a>
<br>
<a id="edit_url" target="edit" style="display: none;">Edit this OSM data</a>
</div>

<div class="hideshow_box">
<span id="hideshow_help_options_show" onclick="hideshow_show('help_options');" class="hideshow_hide">+</span>
<span id="hideshow_help_options_hide" onclick="hideshow_hide('help_options');" class="hideshow_show">-</span>
<span class="hideshow_title">Помощь</span>
<div id="hideshow_help_options_div">
<div class="scrollable">
<b>Quick Start</b>
<br>
Zoom to an area and select one of the buttons to display that type of
data.
<br>
More data options can be found by expanding the details below each
button.
<p>
<b>Data Failure</b>
<br>
If the area selected is too large (depends on the data type) then the
status will say "Failed to get visualiser data" - zoom in and try
again.
</div>
</div>
</div>
</div>

<div class="tab_content" id="tab_router_div" style="display: none;">
<div class="hideshow_box">
<span class="hideshow_title">Routino Router</span>
To perform routing on the map use the link below.
<br>
<a id="router_url" href="router.html" target="router">Link to this map view</a>
</div>
</div>

<div class="tab_content" id="tab_data_div" style="display: none;">
<div class="hideshow_box">
<span class="hideshow_title">Routino Statistics</span>
<div id="statistics_data"></div>
<a id="statistics_link" href="statistics.cgi" onclick="displayStatistics();return(false);">Display data statistics</a>
</div>
</div>

</div>

<!-- Right hand side of window - map -->

<div class="right_panel">
<div class="map" id="map">
<noscript>
<p>
Javascript is <em>required</em> to use this web page because of the interactive map.
</noscript>
</div>
<div class="attribution">
Router: <a href="http://www.routino.org/" target="routino">Routino</a>
|
Geo Data: <span id="attribution_data"></span>
|
Тайлы: <span id="attribution_tile"></span>
</div>
</div>

</body>

</html>
