Make install-jsdeps.sh usable for debian packaging build process:
* split download and installing phace
* run downloading phase by hand
* the installing phase is run in dh build phase

--- bin/install-jsdeps.sh	2017-07-09 15:01:01.675103774 +0200
+++ debian/install-jsdeps.sh	2017-07-09 15:20:06.657867758 +0200
@@ -2,10 +2,7 @@
 <?php
 /*
  +-----------------------------------------------------------------------+
- | bin/install-jsdeps.sh                                                 |
- |                                                                       |
- | This file is part of the Roundcube Webmail client                     |
- | Copyright (C) 2016, The Roundcube Dev Team                            |
+ | debian/install-jsdeps.sh                                              |
  |                                                                       |
  | Licensed under the GNU General Public License version 3 or            |
  | any later version with exceptions for skins & plugins.                |
@@ -14,8 +11,12 @@
  | PURPOSE:                                                              |
  |   Utility script to fetch and install all 3rd party javascript        |
  |   libraries unsed in Roundcube from source.                           |
+ | Modification: see debian/patches/install-jsdeps.patch                 |
+ |    * make it suitable for dh, two run in two steps                    |
  +-----------------------------------------------------------------------+
- | Author: Thomas Bruederli <thomas@roundcube.net>                       |
+ | Author: Sandro Knauß <hefee@debian.org>                               |
+ | based on bin/install-jsdeps.sh from                                   |
+ | Thomas Bruederli <thomas@roundcube.net>                               |
  +-----------------------------------------------------------------------+
 */
 
@@ -44,16 +45,8 @@
 if (empty($FILEINFO)) {
   die("ERROR: Required program 'file' not found\n");
 }
-if (empty($CURL) && empty($WGET)) {
-  die("ERROR: Required program 'wget' or 'curl' not found\n");
-}
-
-$CACHEDIR = sys_get_temp_dir();
-
-if (is_writeable(INSTALL_PATH . 'temp/js_cache') || @mkdir(INSTALL_PATH . 'temp/js_cache', 0774, true)) {
-  $CACHEDIR = INSTALL_PATH . 'temp/js_cache';
-}
 
+$CACHEDIR = 'debian/missing-sources/';
 
 //////////////// License definitions
 
@@ -116,10 +109,9 @@
  */
 function fetch_from_source($package, $useCache = true, &$filetype = null)
 {
-  global $CURL, $WGET, $FILEINFO, $CACHEDIR;
+  global $CURL, $WGET;
 
-  $filetype = pathinfo($package['url'], PATHINFO_EXTENSION) ?: 'tmp';
-  $cache_file = $CACHEDIR . '/' . $package['lib'] . '-' . $package['version'] . '.' . $filetype;
+  $cache_file = extract_filetype($package, false, $filetype);
 
   if (!is_readable($cache_file) || !$useCache) {
     echo "Fetching $package[url]\n";
@@ -134,7 +126,17 @@
     }
   }
 
-  if (!empty($package['sha1']) && ($sum = sha1_file($cache_file)) !== $package['sha1']) {
+  return extract_filetype($package, true, $filetype);
+}
+
+function extract_filetype($package, $check,  &$filetype = null)
+{
+  global $FILEINFO, $CACHEDIR;
+
+  $filetype = pathinfo($package['url'], PATHINFO_EXTENSION) ?: 'tmp';
+  $cache_file = $CACHEDIR . '/' . $package['lib'] . '-' . $package['version'] . '.' . $filetype;
+
+  if ($check == true && !empty($package['sha1']) && ($sum = sha1_file($cache_file)) !== $package['sha1']) {
     die("ERROR: Incorrect sha1 sum of $cache_file. Expected: $package[sha1], got: $sum\n");
   }
 
@@ -145,6 +147,7 @@
   }
 
   return $cache_file;
+
 }
 
 /**
@@ -292,8 +295,8 @@
 
 //////////////// Execution
 
-$args = rcube_utils::get_opt(array('f' => 'force:bool', 'd' => 'delete:bool'))
-        + array('force' => false, 'delete' => false);
+$args = rcube_utils::get_opt(array('f' => 'force:bool', 'd' => 'delete:bool', 'g' => 'get:bool', 'e' => 'extract:bool'))
+        + array('force' => false, 'delete' => false, 'get' => true, 'extract' => true);
 $WHAT = $args[0];
 
 foreach ($SOURCES['dependencies'] as $package) {
@@ -312,14 +315,22 @@
 
   echo "Installing $package[name]...\n";
 
-  $srcfile = fetch_from_source($package, !$args['force'], $filetype);
-
-  if ($filetype === 'zip') {
-    extract_zipfile($package, $srcfile);
-  }
-  else {
-    compose_destfile($package, $srcfile);
+  if ($args['get']) {
+    if (empty($CURL) && empty($WGET)) {
+      die("ERROR: Required program 'wget' or 'curl' not found\n");
+    }
+    $srcfile = fetch_from_source($package, !$args['force'], $filetype);
+  } else {
+    $srcfile = extract_filetype($package, true, $filetype);
   }
 
+  if ($args['extract']) {
+      if ($filetype === 'zip') {
+        extract_zipfile($package, $srcfile);
+      }
+      else {
+        compose_destfile($package, $srcfile);
+      }
+  }
   echo "Done.\n\n";
 }
