// -*- c-basic-offset: 4 -*-
/*
    Rosegarden-4
    A sequencer and musical notation editor.

    This program is Copyright 2000-2006
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>

    The moral right of the authors to claim authorship of this work
    has been asserted.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#include "ExternalTransport.h"

namespace Rosegarden {

const char *const ExternalTransport::getRequestName(TransportRequest request)
{
    // these are only for debug output -- no requirement for i18n

    switch (request) {
	
    case TransportNoChange:    return "NO CHANGE";
    case TransportStop:        return "STOP";
    case TransportStart:       return "START";
    case TransportPlay:        return "PLAY";
    case TransportRecord:      return "RECORD";
    case TransportJumpToTime:  return "JUMP TO TIME";
    case TransportStartAtTime: return "START AT TIME";
    case TransportStopAtTime:  return "STOP AT TIME";
    default:                   return "UNKNOWN";
    }
}

}

