#ifndef REMOTE_H
#define REMOTE_H

#include <cstdio>
using namespace std;

#include "../../module.h"
#include "proxy_module.h"

class Remote : public Module
{
public:
        Remote();
        ~Remote();
	void service();

        virtual string getName() {
                return "Remote";
        }
                        
        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }
        
        string send_on_command(const Path& path, const string& command,
                               const string& parameter);
        string execute_command(const string& command_name, const string& parameter);
private:
        bool get_line(bool nonblocking);
        void shutdown();
private: 
        static DataSetMap* moduleInfo;
        int sending_pipe[2];
        int receiving_pipe[2];
        bool connected;

        bool have_result;
        string result_buffer;
        vector<string> update_buffer;
        vector<string> message_buffer;

        ProxyModule base_proxy;
                        
protected:
        void updated(const string& keyName, const DataSet& data);
};

#endif
