/* there is some code duplication between this and roottext.  this should probably be eliminated by making a common class
 * for the two.
 */

#include "graph.h"
#include "../../module_registry.h"

DataSetMap *Graph::moduleInfo = 0;

Module* graph_constructor()
{
        return new Graph();
}

const DataSetMap& Graph::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Graph floating point data"));
                moduleInfo->set("supported_vars", DataSet("graph,xpos,ypos,width,height,autoscale,background_colour,transparent,samples_before_redraw"));
                moduleInfo->set("supported_var_types", DataSet("table,int,int,int,int,bool,colour,bool,int"));
                moduleInfo->set("supported_var_defaults", DataSet(",0,0,250,250,false,#000000,false,2"));
                moduleInfo->set("overridable", DataSet("false,false,false,false,false,false,false,false,false"));
                moduleInfo->set("table_graph_col_names", DataSet("source,colour"));
                moduleInfo->set("table_graph_col_types", DataSet("childoutput,colour"));
        }
        return *moduleInfo;
}

extern "C" int graph_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Graph", &graph_constructor, Graph::get_module_info_instance());
        return 0;
}

extern "C" void graph_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Graph");
        Graph::destroy_module_info();
}

Graph::Graph()
        : loopCount(0),
          max_num_data(0),
          pixmap(0),
          next_value(0),
          last_scale(0),
          skip_count(0)
{
        openDisplay();
        disp = getDisplay();
        if (disp) {
                /* Create Window */
                XGCValues gcv;
                gcv.graphics_exposures = True;
                XMapWindow(disp,root);
        }
        
        set_x(0);
        set_y(0);
        set_width(250);
        set_height(250);

        background_colour = getColour("Black");
}

Graph::~Graph()
{
	XClearArea(disp, root, get_x(), get_y(), get_width(), get_height(), true);

        closeDisplay();
        rpdbgmsg(getName() << " module destroyed");
}

double Graph::getAutoscale()
{
        int maximum = 0;
        for (vector<vector<int> >::const_iterator i = values.begin(); i != values.end(); ++i) {
                int val = 0;
                const vector<int>& s = *i;
                for (vector<int>::const_iterator j = s.begin(); j != s.end(); ++j) {
                                val += *j;
                }
                if (val > maximum)
                        maximum = val;
        }
        return double(maximum) / 100.0;
}

void Graph::service()
{
        Module::service();
        DrawingArea::service();
}


/* returns true if the pixmap is right to go */
bool Graph::update_pixmap()
{
        double scalingFactor = 1;
        if (autoscale) {
                scalingFactor = getAutoscale();
        }

        if (scalingFactor != last_scale) {
                full_redraw_required = true;
                last_scale = scalingFactor;
        }

        if (pixmap_width != get_width() || pixmap_height != get_height()) {
                if (pixmap != 0) {
                        XFreePixmap(disp, pixmap);
                        pixmap = 0;
                        full_redraw_required = true;
                }
        }
        if (pixmap == 0) {
                pixmap_height = get_height();
                pixmap_width = get_width();
                if (pixmap_height <= 0 || pixmap_width <= 0)
                        return false;
                int depth = DefaultDepth(disp, DefaultScreen(disp));
                pixmap = XCreatePixmap(disp, root, get_width(), get_height(), depth);
                full_redraw_required = true;
        }
        if (full_redraw_required) {
                next_value = 0;
                next_draw = pixmap_width - 1;
                XSetForeground(disp, gc, background_colour);
                XFillRectangle(disp, pixmap, gc, 0, 0, pixmap_width, pixmap_height);
        }
        
        if (scalingFactor > 0) {
                for (int i = next_value; i < values.size(); i++) {
                        int base = 0;
                        
                        XSetForeground(disp, gc, background_colour);
                        XFillRectangle(disp, pixmap, gc, next_draw, 0, 1, pixmap_height);
                                        
                        for (int j = 0; j < values[i].size(); j++) {
                                int v = int((values[i][j] * (get_height() - 1) / 100) / scalingFactor);
                                if (v < 0)
                                        v = 0;
                                XSetForeground(disp, gc, colours[j]);
                                
                                XFillRectangle(disp, pixmap, gc, next_draw, get_height() - v - base, 1, v);
                                base += v;
                        }
                        next_draw++;
                        if (next_draw >= pixmap_width)
                                next_draw = 0;
                }
                next_value = values.size();
        }
        return true;
}


void Graph::redraw(XExposeEvent *ev)
{
        if (transparent) {
                double scalingFactor = 1;
                if (autoscale) {
                        int maximum = 0;
                        for (vector<vector<int> >::const_iterator i = values.begin(); i != values.end(); ++i) {
                                int val = 0;
                                const vector<int>& s = *i;
                                for (vector<int>::const_iterator j = s.begin(); j != s.end(); ++j) {
                                        val += *j;
                                }
                                if (val > maximum)
                                        maximum = val;
                        }
                        scalingFactor = double(maximum) / 100.0;
                }

                if (scalingFactor > 0) {
                        int n = 0;
                        for (vector<vector<int> >::const_iterator i = values.begin(); i != values.end(); ++i) {
                                int base = 0;
                                const vector<int>& s = *i;
                                for (int j = 0; j < s.size(); j++) {
                                        if (n < width) {
                                                int v = int((s[j] * (height - 1) / 100) / scalingFactor);
                                                if (v < 0)
                                                        v = 0;
                                                XSetForeground(disp, gc, colours[j]);
                                                XFillRectangle(disp, root, gc, x + n, y + height - v - base, 1, v);
                                                base += v;
                                        }
                                }
                                XClearArea(disp, root, x + n, y, 1, height - base, false);
                                n++;
                        }
                } else {
                        erase();
                }
//                  double scalingFactor = 1;
//                  if (autoscale) {
//                          scalingFactor = getAutoscale();
//                  }

//                  if (scalingFactor > 0) {
//                          int n = 0;
//                          for (vector<vector<int> >::const_iterator i = values.begin(); i != values.end(); ++i) {
//                                  int base = 0;
//                                  const vector<int>& s = *i;
//                                  for (int j = 0; j < s.size(); j++) {
//                                          if (n < get_width()) {
//                                                  int v = int((s[j] * (get_height() - 1) / 100) / scalingFactor);
//                                                  if (v < 0)
//                                                          v = 0;
//                                                  XSetForeground(disp, gc, colours[j]);
//                                                  XFillRectangle(disp, root, gc, get_x() + n,
//                                                                 get_y() + get_height() - v - base, 1, v);
//                                                  base += v;
//                                          }
//                                  }
//                                  XClearArea(disp, root, get_x() + n, get_y(), 1, get_height() - base, true);
//                                  n++;
//                          }
//                  } else {
//                          erase();
//                  }
        } else {
                if (ev == NULL)
                        if (!update_pixmap())
                                return;
                if (next_draw >= pixmap_width) {
                        XCopyArea(disp, pixmap, root, gc, 0, 0, get_width(), get_height(), get_x(), get_y());
                } else {
                        XCopyArea(disp, pixmap, root, gc, 0, 0, next_draw, get_height(),
                                  get_x() + get_width() - next_draw , get_y());
                        XCopyArea(disp, pixmap, root, gc, next_draw, 0, get_width() - next_draw,
                                  get_height(), get_x(), get_y());
                }
                full_redraw_required = false;
        }
}

Pixel Graph::getColour(const string& colourName)
{
	XColor colour;
	XWindowAttributes attributes;

	XGetWindowAttributes(disp, root, &attributes);

	colour.pixel = 0;

	if (!XParseColor(disp, attributes.colormap, colourName.c_str(), &colour))
		cerr << "can't parse colour " << colourName << endl;
	else if(!XAllocColor(disp, attributes.colormap, &colour))
		cerr << "can't allocate colour " << colourName << endl;
	return colour.pixel;
}

void Graph::updated(const string& keyName, const DataSet& data)
{
        knownUpdateKey = true;
        if (keyName == "graph") {
                sources.clear();
                colours.clear();
                for (int i = 0; i < data.count(); i += 2) {
                        if (data.validIndex(i + 1)) {
                                sources.push_back(data.getString(i));
                                colours.push_back(getColour(data.getString(i + 1)));
                        }
                }
        } else if (keyName == "xpos") {
                set_x(data.getInt());
                redraw(NULL);
        } else if (keyName == "ypos") {
                set_y(data.getInt());
                redraw(NULL);
        } else if (keyName == "width") {
                set_width(data.getInt());
                redraw(NULL);
        } else if (keyName == "length") {
                set("height", data);
                redraw(NULL);
        } else if (keyName == "height") {
                set_height(data.getInt());
                redraw(NULL);
        } else if (keyName == "autoscale") {
                autoscale = data.getBool();
        } else if (keyName == "background_colour") {
                background_colour = getColour(data.getString());
                full_redraw_required = true;
                redraw(NULL);
        } else if (keyName == "transparent") {
                transparent = data.getBool();
                full_redraw_required = true;
                redraw(NULL);
        } else if (keyName == "samples_before_redraw") {
                redraw_skip = data.getInt();
        } else
                knownUpdateKey = false;
}

void Graph::outputReceived(const DataSetMap& output)
{
        Module::outputReceived(output);
        if (!knownUpdateKey) {
                vector<int> newVals;
                for (vector<string>::const_iterator i = sources.begin(); i != sources.end(); ++i) {
                        if (env.validIndex(*i))
                                newVals.push_back(env[*i].getInt());
                        else
                                newVals.push_back(0);
                }
                values.push_back(newVals);
                if (newVals.size() > max_num_data)
                        max_num_data = newVals.size();
                while (values.size() > get_width()) {
                        values.erase(values.begin());
                        next_value--;
                }
                
                skip_count++;
                if (skip_count >= redraw_skip) {
                        redraw(NULL);
                        skip_count = 0;
                }
        }
}
