#ifndef DATASETMAP_H
#define DATASETMAP_H

#include "dataset.h"

#include <map>
#include <string>
#include <ctime>
using namespace std;

class DataSetMap
{
public:
        void set(const string& key, const DataSet& value);        
        bool validIndex(const string& key) const
                {return storage.count(key) > 0;};
        const DataSet& operator[](const string& key) const {
                assert(validIndex(key));
                return storage.find(key)->second;
        };
        DataSet& operator[](const string& key) {
                assert(validIndex(key));
                return storage.find(key)->second;
        };
        void remove(const string& key) {
                assert(validIndex(key));
                storage.erase(storage.find(key));
        };
        void display(ostream& os) const;
        int count() const {return storage.size();};
        void getExpanded(string& result, const string& key, int cPosition = 0) const;
        void expand(string& result, const string& value, int c_position = 0) const;
        void integrate(const DataSetMap& other);
        void clear() {
                storage.clear();
        }

        int getInt(const string& key, int index, int defaultValue) const {
                try {
                        if (validIndex(key))
                                return storage.find(key)->second.getInt(index);
                        return defaultValue;
                } catch (BadDataType) {
                        return defaultValue;
                } catch (InvalidIndex) {
                        return defaultValue;
                }               
        };
        bool getBool(const string& key, int index, bool defaultValue) const {
                try {
                        if (validIndex(key))
                                return storage.find(key)->second.getBool(index);
                        return defaultValue;
                } catch (BadDataType) {
                        return defaultValue;
                } catch (InvalidIndex) {
                        return defaultValue;
                }               
        };
        double getDouble(const string& key, int index, double defaultValue) const {
                try {
                        if (validIndex(key))
                                return storage.find(key)->second.getDouble(index);
                        return defaultValue;
                } catch (BadDataType) {
                        return defaultValue;
                } catch (InvalidIndex) {
                        return defaultValue;
                }               
        };
        string getString(const string& key, int index, const string& defaultValue) const {
                try {
                        if (validIndex(key))
                                return storage.find(key)->second.getString(index);
                        return defaultValue;
                } catch (BadDataType) {
                        return defaultValue;
                } catch (InvalidIndex) {
                        return defaultValue;
                }               
        };

        typedef map<string, DataSet>::const_iterator const_iterator;
        typedef map<string, DataSet>::iterator iterator;
        const_iterator begin() const {return storage.begin();};
        const_iterator end() const {return storage.end();};
        iterator begin() {return storage.begin();};
        iterator end() {return storage.end();};
private:
        struct tm *getTime() const;
        map<string, DataSet> storage;
};

inline ostream& operator<<(ostream& os, const DataSetMap& dtsetmap)
{
        dtsetmap.display(os);
        return os;
}

#endif
