#* 
#* ------------------------------------------------------------------
#* Role PlayingDB V2.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* RPGEdSpell.tcl - Spell Editor
#* Created by Robert Heller on Wed Aug 19 16:30:43 1998
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: RPGEdSpell.tcl,v $
#* Revision 1.2  1999/07/13 01:29:16  heller
#* Fix documentation: spelling, punctuation, etc.
#*
#* Revision 1.1  1998/12/28 02:33:27  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Role Playing DB -- A database package that creates and maintains
#* 		       a database of RPG characters, monsters, treasures,
#* 		       spells, and playing environments.
#* 
#*     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter:RPGEdSpell.tcl -- Magical activities
#@Label:RPGEdSpell.tcl
#$Id: RPGEdSpell.tcl,v 1.2 1999/07/13 01:29:16 heller Rel1 $
# This file contains the code to create and edit spell objects.  These
# objects describe what is needed to cast magic spells.


proc RPGEdSpell {{filename {}}} {
# This procedure creates or edits a spell object.
# <in> filename -- the file to edit.
# [index] RPGEdSpell!procedure

  global tk_version
  set toplevel [GenerateToplevelName rpgEdSpe]

  RPGToplevel .$toplevel {Role Playing V2 Spell Editor} Spell
  wm withdraw .$toplevel
  global .$toplevel
  upvar #0 .$toplevel data
  set data(filename) "$filename"
  set data(filetype) "spell"
  if {[string length "$filename"] > 0} {
    set data(object) [Spell]
    set object $data(object)
    if {[file readable "$filename"]} {
    set buffer [Record]
      if {[catch [list $buffer ReadRecord "$filename"] err]} {
        CloseWindow .$toplevel
        tkerror "Could not load $filename: $err"
        return
      }
      if {[string compare {*Spell} "[lindex [$buffer ReturnRecord] 0]"] != 0} {
	CloseWindow .$toplevel
	tkerror "Not a Spell file: $filename"
	return
      }
      $object UpdateFromRecord $buffer
      rename $buffer {}
    } else {
      CloseWindow .$toplevel
      tkerror "File does not exist or is not readable: $filename"
      return
    }
  } else {
    set data(object) [Spell]
    set object $data(object)
    set data(dirty) 0
  }

  # build widget .$toplevel.attributes
  frame .$toplevel.attributes \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.attributes.left
  frame .$toplevel.attributes.left

  # build widget .$toplevel.attributes.left.spellClass
  frame .$toplevel.attributes.left.spellClass

  # build widget .$toplevel.attributes.left.spellClass.label15
  label .$toplevel.attributes.left.spellClass.label15 \
    -text {Class:}

  # build widget .$toplevel.attributes.left.spellClass.value
  entry .$toplevel.attributes.left.spellClass.value \
    -width {0} \
    -textvariable ".[set toplevel](spellClass)"
  bind .$toplevel.attributes.left.spellClass.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.left.name
  frame .$toplevel.attributes.left.name

  # build widget .$toplevel.attributes.left.name.label15
  label .$toplevel.attributes.left.name.label15 \
    -text {Name:}

  # build widget .$toplevel.attributes.left.name.value
  entry .$toplevel.attributes.left.name.value \
    -width {0} \
    -textvariable ".[set toplevel](name)"
  bind .$toplevel.attributes.left.name.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.left.area
  frame .$toplevel.attributes.left.area

  # build widget .$toplevel.attributes.left.area.label15
  label .$toplevel.attributes.left.area.label15 \
    -text {Effected Area:}

  # build widget .$toplevel.attributes.left.area.value
  entry .$toplevel.attributes.left.area.value \
    -width {0} \
    -textvariable ".[set toplevel](area)"
  bind .$toplevel.attributes.left.area.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.left.castTime
  frame .$toplevel.attributes.left.castTime

  # build widget .$toplevel.attributes.left.castTime.label15
  label .$toplevel.attributes.left.castTime.label15 \
    -text {Casting Time:}

  # build widget .$toplevel.attributes.left.castTime.value
  entry .$toplevel.attributes.left.castTime.value \
    -width {0} \
    -textvariable ".[set toplevel](castTime)"
  bind .$toplevel.attributes.left.area.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.left.duration
  frame .$toplevel.attributes.left.duration

  # build widget .$toplevel.attributes.left.duration.label15
  label .$toplevel.attributes.left.duration.label15 \
    -text {Duration:}

  # build widget .$toplevel.attributes.left.duration.value
  entry .$toplevel.attributes.left.duration.value \
    -width {0} \
    -textvariable ".[set toplevel](duration)"
  bind .$toplevel.attributes.left.duration.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.right
  frame .$toplevel.attributes.right

  # build widget .$toplevel.attributes.right.level
  frame .$toplevel.attributes.right.level

  # build widget .$toplevel.attributes.right.level.label15
  label .$toplevel.attributes.right.level.label15 \
    -text {Level:}

  # build widget .$toplevel.attributes.right.level.value
  entry .$toplevel.attributes.right.level.value \
    -width {0} \
    -textvariable ".[set toplevel](level)"
  bind .$toplevel.attributes.right.level.value <KeyPress> "SetDirty .$toplevel"
  bindtags .$toplevel.attributes.right.level.value \
    [list .$toplevel.attributes.right.level.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.spellType
  frame .$toplevel.attributes.right.spellType

  # build widget .$toplevel.attributes.right.spellType.label15
  label .$toplevel.attributes.right.spellType.label15 \
    -text {Type:}

  # build widget .$toplevel.attributes.right.spellType.value
  entry .$toplevel.attributes.right.spellType.value \
    -width {0} \
    -textvariable ".[set toplevel](spellType)"
  bind .$toplevel.attributes.right.spellType.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.right.range
  frame .$toplevel.attributes.right.range

  # build widget .$toplevel.attributes.right.range.label15
  label .$toplevel.attributes.right.range.label15 \
    -text {Range:}

  # build widget .$toplevel.attributes.right.range.value
  entry .$toplevel.attributes.right.range.value \
    -width {0} \
    -textvariable ".[set toplevel](range)"
  bind .$toplevel.attributes.right.range.value <KeyPress> "SetDirty .$toplevel"
  bindtags .$toplevel.attributes.right.range.value \
    [list .$toplevel.attributes.right.range.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.savingThrow
  frame .$toplevel.attributes.right.savingThrow

  # build widget .$toplevel.attributes.right.savingThrow.label15
  label .$toplevel.attributes.right.savingThrow.label15 \
    -text {Saving Throw:}

  # build widget .$toplevel.attributes.right.savingThrow.value
  entry .$toplevel.attributes.right.savingThrow.value \
    -width {0} \
    -textvariable ".[set toplevel](savingThrow)"
  bind .$toplevel.attributes.right.savingThrow.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.right.fill
  frame .$toplevel.attributes.right.fill

  # build widget .$toplevel.flags
  frame .$toplevel.flags \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.flags.checkbutton17
  checkbutton .$toplevel.flags.checkbutton17 \
    -relief {raised} \
    -text {Reversible?} \
    -variable ".[set toplevel](reversible)" \
    -command "SetDirty .$toplevel"

  # build widget .$toplevel.flags.checkbutton18
  checkbutton .$toplevel.flags.checkbutton18 \
    -relief {raised} \
    -text {Verbal?} \
    -variable ".[set toplevel](verbal)" \
    -command "SetDirty .$toplevel"

  # build widget .$toplevel.flags.checkbutton19
  checkbutton .$toplevel.flags.checkbutton19 \
    -relief {raised} \
    -text {Somatic?} \
    -variable ".[set toplevel](somatic)" \
    -command "SetDirty .$toplevel"

  # build widget .$toplevel.flags.checkbutton20
  checkbutton .$toplevel.flags.checkbutton20 \
    -relief {raised} \
    -text {Material?} \
    -variable ".[set toplevel](material)" \
    -command "SetDirty .$toplevel"

  # build widget .$toplevel.description
  frame .$toplevel.description \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.description.scrollbar1
  scrollbar .$toplevel.description.scrollbar1 \
    -command ".$toplevel.description.value yview" \
    -relief {raised}

  # build widget .$toplevel.description.value
  text .$toplevel.description.value \
    -height {5} \
    -width {60} \
    -wrap {word} \
    -yscrollcommand ".$toplevel.description.scrollbar1 set"
  bindtags .$toplevel.description.value \
    [list .$toplevel.description.value Text .$toplevel all UpdComments]

  # build widget .$toplevel.buttons
  frame .$toplevel.buttons \
    -borderwidth {2}

  # build widget .$toplevel.buttons.button21
  button .$toplevel.buttons.button21 \
    -text {Load} \
    -command "LoadSpell .$toplevel"

  # build widget .$toplevel.buttons.button22
  button .$toplevel.buttons.button22 \
    -text {Save} \
    -command "SaveSpell .$toplevel"

  # pack master .$toplevel.attributes
  pack configure .$toplevel.attributes.left \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.attributes.right \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left
  pack configure .$toplevel.attributes.left.spellClass \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.name \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.area \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.castTime \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.duration \
    -expand 1 \
    -fill x

  # pack master .$toplevel.attributes.left.spellClass
  pack configure .$toplevel.attributes.left.spellClass.label15 \
    -side left
  pack configure .$toplevel.attributes.left.spellClass.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.name
  pack configure .$toplevel.attributes.left.name.label15 \
    -side left
  pack configure .$toplevel.attributes.left.name.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.area
  pack configure .$toplevel.attributes.left.area.label15 \
    -side left
  pack configure .$toplevel.attributes.left.area.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.castTime
  pack configure .$toplevel.attributes.left.castTime.label15 \
    -side left
  pack configure .$toplevel.attributes.left.castTime.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.duration
  pack configure .$toplevel.attributes.left.duration.label15 \
    -side left
  pack configure .$toplevel.attributes.left.duration.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right
  pack configure .$toplevel.attributes.right.level \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.spellType \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.range \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.savingThrow \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.fill \
    -expand 1 \
    -fill x

  # pack master .$toplevel.attributes.right.level
  pack configure .$toplevel.attributes.right.level.label15 \
    -side left
  pack configure .$toplevel.attributes.right.level.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.spellType
  pack configure .$toplevel.attributes.right.spellType.label15 \
    -side left
  pack configure .$toplevel.attributes.right.spellType.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.range
  pack configure .$toplevel.attributes.right.range.label15 \
    -side left
  pack configure .$toplevel.attributes.right.range.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.savingThrow
  pack configure .$toplevel.attributes.right.savingThrow.label15 \
    -side left
  pack configure .$toplevel.attributes.right.savingThrow.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.flags
  pack configure .$toplevel.flags.checkbutton17 \
    -expand 1 \
    -side left
  pack configure .$toplevel.flags.checkbutton18 \
    -expand 1 \
    -side left
  pack configure .$toplevel.flags.checkbutton19 \
    -expand 1 \
    -side left
  pack configure .$toplevel.flags.checkbutton20 \
    -expand 1 \
    -side left

  # pack master .$toplevel.description
  pack configure .$toplevel.description.scrollbar1 \
    -fill y \
    -side right
  pack configure .$toplevel.description.value \
    -expand 1 \
    -fill both

  # pack master .$toplevel.buttons
  pack configure .$toplevel.buttons.button21 \
    -expand 1 \
    -side left
  pack configure .$toplevel.buttons.button22 \
    -expand 1 \
    -side left

  # pack master .$toplevel
  pack configure .$toplevel.attributes \
    -expand 1 \
    -fill both
  pack configure .$toplevel.flags \
    -expand 1 \
    -fill x
  pack configure .$toplevel.description \
    -fill both
  pack configure .$toplevel.buttons \
    -expand 1 \
    -fill x

  set data(spellClass) "[$object SpellClass]"
  set data(name) "[$object Name]"
  set data(area) "[$object AreaOfEffect]"
  set data(castTime) "[$object CastingTime]"
  set data(duration) "[$object Duration]"
  set data(level) [$object Level]
  set data(spellType) "[$object SpellType]"
  set data(range) [$object Range]
  set data(savingThrow) "[$object SavingThrow]"
  set data(comments) "[$object Description]"
  .$toplevel.description.value insert end "$data(comments)"
  set data(reversible) [$object ReversibleP]
  set data(verbal) [$object VerbalP]
  set data(somatic) [$object SomaticP]
  set data(material) [$object MaterialP]

  rename $object {}

# end of widget tree

  update
  set hfill [winfo reqheight .$toplevel.attributes.left.spellClass]
  set wfill [winfo reqheight .$toplevel.attributes.right.range]
  .$toplevel.attributes.right.fill configure \
    -height $hfill -width $wfill

  wm deiconify .$toplevel
}

proc CheckWriteDirtyRecordSpell {tl} {
# This procedure is called when the GUI window is being closed and the data
# is ``dirty'' (modified).  It takes care of saving the data if the user
# wants to.
# <in> tl -- the toplevel.
# [index] CheckWriteDirtyRecordSpell!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set saveP [tk_dialog .askDirty "Save spell?" "Save modified Spell data?" \
	questhead 0 "Yes" "No"]
  if {$saveP == 0} {
    set object [Spell -this [NewSpell \
			-class "$data(spellClass)" \
			-name  "$data(name)" \
			-type  "$data(spellType)" \
			-description "$data(comments)" \
			-area  "$data(area)" \
			-casttime "$data(castTime)" \
			-duration "$data(duration)" \
			-savethrow "$data(savingThrow)" \
			-level $data(level) \
			-range $data(range) \
			-reversible $data(reversible) \
			-verbal $data(verbal) \
			-somatic $data(somatic) \
			-material $data(material)]]
    set buffer [Record -this [$object RawData]]
    if {[string length "$filename"] == 0} {
      set filename [tk_getSaveFile -defaultextension ".$filetype" \
      				   -initialfile "new.$filetype" \
				   -initialdir "[pwd]" \
				   -filetypes [list [list "Spell files" \
							  "*.$filetype"]]\
				   -parent . \
				   -title {File to save spell data in}]
      if {[string length "$filename"] == 0} {return}
      if {[string length "[file extension $filename]"] == 0} {
	set filename "$filename.$filetype"
      }
    }
    $buffer WriteRecord "$filename"
    rename $buffer {}
    rename $object {}
  }
}

proc LoadSpell {tl} {
# This procedure loads a spell data file into the current toplevel GUI window.
# <in> tl -- the toplevel GUI.
# [index] LoadSpell!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  if {$data(dirty)} {
    set saveP [tk_dialog .askDirty "Save spell?" \
		"Save modified Spell data?" \
		questhead 0 "Yes" "No"]
    if {$saveP == 0} {SaveSpell $tl}
  }
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set filename [tk_getOpenFile -defaultextension ".$filetype" \
				   -initialfile "$filename" \
                                   -initialdir "$initdir" \
                                   -filetypes [list [list "Spell files" \
							  "*.$filetype"]]\
                                   -parent $tl \
                                   -title {File to load spell data from}]
  if {[string length "$filename"] == 0} {return}
  set buffer [Record]
  if {[catch [list $buffer ReadRecord "$filename"] err]} {
    tkerror "Could not load file $filename: $err"
    rename $buffer {}
    return
  }
  set key [lindex [$buffer ReturnRecord] 0]
  if {[string compare "$key" {*Spell}] != 0} {
    rename $buffer {}
    tkerror "Not a spell file: $filename"
    return
  }
  set object [Spell]
  $object UpdateFromRecord $buffer
  rename $buffer {}
  set data(spellClass) "[$object SpellClass]"
  set data(name) "[$object Name]"
  set data(area) "[$object AreaOfEffect]"
  set data(castTime) "[$object CastingTime]"
  set data(duration) "[$object Duration]"
  set data(level) [$object Level]
  set data(spellType) "[$object SpellType]"
  set data(range) [$object Range]
  set data(savingThrow) "[$object SavingThrow]"
  set data(comments) "[$object Description]"
  $tl.description.value insert end "$data(comments)"
  set data(reversible) [$object ReversibleP]
  set data(verbal) [$object VerbalP]
  set data(somatic) [$object SomaticP]
  set data(material) [$object MaterialP]
  rename $object {}
}

proc SaveAsSpell {tl} {
# This procedure saves the current data object in a named file.
# <in> tl -- the toplevel.
# [index] SaveAsSpell!procedure

  SaveSpell $tl 1
}

proc SaveSpell {tl {forceNew 0}} {
# This procedure saves the current data object in a named file.
# <in> tl -- the toplevel.
# <in> forceNew -- flag to force a new file name.
# [index] SaveSpell!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set object [Spell -this [NewSpell \
			-class "$data(spellClass)" \
			-name  "$data(name)" \
			-type  "$data(spellType)" \
			-description "$data(comments)" \
			-area  "$data(area)" \
			-casttime "$data(castTime)" \
			-duration "$data(duration)" \
			-savethrow "$data(savingThrow)" \
			-level $data(level) \
			-range $data(range) \
			-reversible $data(reversible) \
			-verbal $data(verbal) \
			-somatic $data(somatic) \
			-material $data(material)]]
  set buffer [Record -this [$object RawData]]
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  if {[string length "$filename"] == 0} {
    set initfile "new.$filetype"
  } else {
    set initfile "$filename"
  }
  if {$forceNew || [string length "$filename"] == 0} {
    set filename [tk_getSaveFile -defaultextension ".$filetype" \
      				   -initialfile "$initfile" \
				   -initialdir "$initdir" \
				   -filetypes [list [list "Spell files" \
							  "*.$filetype"]]\
				   -parent . \
				   -title {File to save spell data in}]
    if {[string length "$filename"] == 0} {return}
    if {[string length "[file extension $filename]"] == 0} {
	set filename "$filename.$filetype"
    }
  }
  $buffer WriteRecord "$filename"
  rename $buffer {}
  rename $object {}
  set data(dirty) 0
  set data(filename) "$filename"
}

proc OpenSpell {tl} {
# This procedure opens a spell object data file in a new toplevel GUI window.
# <in> tl -- the current toplevel GUI.
# [index] OpenSpell!procedure

  if {"$tl" == {.}} {
    set data(filename) {}
    set data(filetype) spell
    set data(class) Spell
  } else {
    upvar #0 $tl data
  }
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set filename [tk_getOpenFile -defaultextension ".$data(filetype)" \
			   -filetypes [list [list "$data(class) files" \
					"*.$filetype"]]\
			   -parent $tl \
			   -initialfile "$filename" \
			   -initialdir "$initdir" \
			   -title "File to load $data(class) data from"]
  if {[string length "$filename"] == 0} {return}
  RPGEd$data(class) "$filename"
}

package provide RPGEdSpell 1.0


