/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Record.h - Record class
 * Created by Robert Heller on Tue Jul 14 12:02:53 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Record.h,v $
 * Revision 1.2  1999/07/13 00:29:40  heller
 * Documentation updates (spelling, punctionation, spelling, caps/nocaps).
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _RECORD_H_
#define _RECORD_H_

#include <stdlib.h>
#include <string.h>


/*@ManDoc:
 \typeout{Generated from $Id: Record.h,v 1.2 1999/07/13 00:29:40 heller Rel1 $.}
 Record structure.

  Core resident record - it has a size and a chunk of memory (the
  record itself). This structure is lifted from the Home Librarian
  package.  A very re-usable piece of code.

   Lots of fun.  I wish C++ had a garbage collector...
 */
struct Record {
	//@ManDoc: Size of the record.
	size_t size;
	//@ManDoc: Buffer for the data.
	char *buffer;
	//@ManDoc: Base constructor: empty buffer.
	     Record () {size = 0; buffer = 0;}		// empty buffer
	//@ManDoc: Constructor: preallocated buffer.
	     Record (size_t size) {Record::size = size; // preallocated buffer
				     buffer = new char[size];
				     }
	//@ManDoc: Constructor: record from another record.
	     Record (const Record& rec)	{
			size = rec.size;
			if (size > 0) {
				buffer = new char[size];
				memcpy(buffer,rec.buffer,size);
			}
		}
	//@ManDoc: Destructor: free up allocated memory.
	    ~Record () {
		if (size > 0) {
			delete buffer;
		}
		buffer = 0;
	     } // Oh for a GC!
	//@ManDoc: Assignment operator (copy a record) -- allocate fresh memory.
	Record& operator = (const Record& rec)	{
			if (size < rec.size) {
				if (buffer !=0) delete buffer;
				buffer = new char[rec.size];
			} else if (rec.size <= 0 && size > 0) {
			    delete buffer; buffer = 0; size = 0;
			}
			size = rec.size;
			if (rec.size > 0)
			    memcpy(buffer,rec.buffer,rec.size);
			return *this;
		}
	//@ManDoc: Buffer (re-)allocator function.
	void NewBuffer(size_t size) {
			if (Record::size > 0) {
				delete buffer; buffer = 0; Record::size = 0;
			}
			Record::size = size;
			if (size > 0) {
				buffer = new char[size];
			}
		}			
};




#endif // _RECORD_H_

