/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/* ddt.cc
 *    c++ test code for the c++ wrapper to the lib.
 *
 * $Id: ddt2.cc,v 1.2 2001/03/27 23:00:46 remi Exp $
 *
 * Copyright (C) 2000, 2001 Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#include <iostream>
#include <string.h>
#include "gpcp++.h"

struct hostentry
{
    string hostaddr;
    unsigned int serverport;
    unsigned int clientport;
    string interface;
    int accountid;
    string password;
    bool encrypt;
};

// define the config tree
Options ddt_options[] = {
     {"debug",       BOOLEAN, NULL},
     {"hostentry",   PARENT,  NULL},
     {"hostaddr",    STRING,  "hostentry"},
     {"serverport",  INTEGER, "hostentry"},
     {"clientport",  INTEGER, "hostentry"},
     {"interface",   STRING,  "hostentry"},
     {"accountid",   INTEGER, "hostentry"},
     {"password",    STRING,  "hostentry"},
     {"encrypt",     BOOLEAN, "hostentry"},
     {NULL,          (Types) 0,  NULL}
};

int main(void)
{
    GPCP config("ddt.conf", ddt_options);

    bool debug;
    int n;
    struct hostentry *hosts;

    if (config.get("debug", debug) != 0)
    {
        cout << "can't get debug value" << endl;
    }

    if ((n = config.parents("hostentry")) == 0)
    { 
        cout << "no hostentry available" << endl;
    }

    hosts = new struct hostentry[sizeof(struct hostentry) * n];

    for (int i = 0; i < n; i++)
    {
        config.inlevel("hostentry", i);
        config.get("hostaddr", hosts[i].hostaddr);
        config.get("serverport", static_cast<int>(hosts[i].serverport));
        config.get("clientport", static_cast<int>(hosts[i].clientport));
        config.get("interface", hosts[i].interface);
        config.get("accountid", hosts[i].accountid);
        config.get("password", hosts[i].password);
        config.get("encrypt", hosts[i].encrypt);
        config.outlevel();
    }

    for (int i = 0; i < n; i++)
    {
        cout << hosts[i].hostaddr << " " << hosts[i].serverport
             << " " << hosts[i].clientport << " " << hosts[i].interface
             << " " << hosts[i].accountid << " " << hosts[i].password
             << " " << hosts[i].encrypt << endl;
    }
    
    delete [] hosts;
}
