/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */

/* gpcp++.h
 *    header file of c++ wrapper lib.
 *
 * $Id: gpcp++.h,v 1.2 2001/03/27 23:00:46 remi Exp $
 *
 * Copyright (C) 2000 Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#ifndef __gpcpxx_h__
#define __gpcpxx_h__

#include <string>

extern "C" {
#include "gpcp.h"
}

class GPCP
{
public:
    GPCP(char *filename, Options *options);
    ~GPCP();

    /* get the value of varname. returns true if succesful */
    int get(char *varname, string& str); // str
    int get(char *varname, float& val); // float
    int get(char *varname, int& val); // int
    int get(char *varname, bool& val); // bool

    int parents(char *parname) { return GPCP_NumParent(parname); }
    int inlevel(char *lname, int rank) { return GPCP_EnterLevel(lname, rank); }
    int outlevel() { return GPCP_ExitLevel(); }

//private:
    Data *cdata;
};

#endif // __gpcpxx_h__
