//network.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_NETWORK_H_
#define _RPLD_NETWORK_H_

#define RPLD_SOCKNAME_UNIX   "./.rpld"
#define RPLD_SOCKNAME_TCP    "localhost"
#define RPLD_SOCKNAME_DECNET "::rpld"
#define RPLD_SOCKNAME        RPLD_SOCKNAME_UNIX
#define RPLD_PORT            24148
#define RPLD_MAX_LISTEN      4

struct {
 struct roar_vio_calls sock;
 int proto;
 char * server;
 enum rpld_client_acclev acclev;
} g_listen[RPLD_MAX_LISTEN];

int  network_preinit(void);

int  network_add_server(char * server, int port, int type, int proto, enum rpld_client_acclev acclev);

int  network_init(void);
void network_uninit(void);

void network_check(int block);

#endif

//ll
