//yield.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "rpld.h"

static struct {
 int task;
 int block;
 void (*func)(int block);
} _g_yield_tasks[] = {
 {RPLD_YIELD_TASK_NETWORK,  RPLD_YIELD_NONBLOCK, network_check },
 {RPLD_YIELD_TASK_PLAYBACK, RPLD_YIELD_NONBLOCK, playback_check},
 {-1, 1, NULL}
};

void yield(int ptasks, int ntasks, int block) {
 int i;

 ptasks |= ntasks;
 ptasks -= ntasks;

 if ( ptasks == 0 )
  return;

 for (i = 0; _g_yield_tasks[i].task != -1; i++) {
  if ( !(_g_yield_tasks[i].task & ptasks) )
   continue;

  if ( _g_yield_tasks[i].block > block )
   continue;

  _g_yield_tasks[i].func(block);
 }
}

//ll
