//echo.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2012
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roard/include/roard.h>

static int check_client(int client, struct roar_vio_calls * vio) {
 struct roar_buffer * buf;
 void * data;
 ssize_t len;

 ROAR_DBG("check_client(client=%i, vio=%p) = ?", client, vio);

 if ( roar_buffer_new_data(&buf, 1024, &data) == -1 )
  return -1;

 len = roar_vio_read(vio, data, 1024);

 if ( len < 1 ) {
  clients_delete(client);
  return -1;
 }

 if ( roar_buffer_set_len(buf, len) == -1 ) {
  roar_buffer_free(buf);
  clients_delete(client);
  return -1;
 }

 clients_add_output(client, &buf);

 ROAR_DBG("check_client(client=%i, vio=%p) = 0", client, vio);
 return 0;
}


static struct roard_proto proto[1] = {
 {ROAR_PROTO_ECHO, ROAR_SUBSYS_NONE, "Send all data send to the server back to the client", NULL, NULL, NULL, check_client, NULL, NULL}
};

ROARD_DL_REG_PROTO(proto)

ROAR_DL_PLUGIN_START(protocol_echo) {
 ROARD_DL_CHECK_VERSIONS();

 ROAR_DL_PLUGIN_META_PRODUCT_NIV("protocol-echo", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0);
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");
 ROAR_DL_PLUGIN_META_DESC("Implementation of a dummy protocol sending all data back to the sender");

 ROARD_DL_REGFN_PROTO();
} ROAR_DL_PLUGIN_END

//ll
