//daytime.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2012
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roard/include/roard.h>

int new_client(int client, struct roar_vio_calls * vio, struct roard_listen * lsock) {
 struct roar_buffer * buf;
 void * data;
 ssize_t len;
 time_t now = time(NULL);
 char * date = asctime(gmtime(&now));

 (void)vio, (void)lsock;

 ROAR_DBG("new_client(client=%i, vio=%p, lsock=%p) = ?", client, vio, lsock);

 len = roar_mm_strlen(date) + 1;

 if ( roar_buffer_new_data(&buf, len, &data) == -1 )
  return -1;

 memcpy(data, date, len);

 clients_add_output(client, &buf);

 ROAR_DBG("new_client(client=%i, vio=%p, lsock=%p) = 0", client, vio, lsock);
 return 0;
}

static int flushed_client(int client, struct roar_vio_calls * vio) {
 (void)vio;

 clients_delete(client);

 return 0;
}

static struct roard_proto proto[1] = {
 {ROAR_PROTO_DAYTIME, ROAR_SUBSYS_NONE, "The Internet daytime protocol", NULL, new_client, NULL, NULL, NULL, flushed_client}
};

ROARD_DL_REG_PROTO(proto)

ROAR_DL_PLUGIN_START(protocol_daytime) {
 ROARD_DL_CHECK_VERSIONS();

 ROAR_DL_PLUGIN_META_PRODUCT_NIV("protocol-daytime", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0);
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");
 ROAR_DL_PLUGIN_META_DESC("Implementation of the Internet daytime protocol");

 ROARD_DL_REGFN_PROTO();
} ROAR_DL_PLUGIN_END

//ll
