#!/bin/sh
# $Id: update-inetd.sh,v 1.3 2005/01/04 17:13:12 robert Exp $
#
# rlinetd's version of update-inetd.
# Robert Luberda <robert@debian.org>, Aug 2001
#

set -e

PATH=/usr/sbin:$PATH

version='$Revision: 1.3 $'
line=""
last=""

for i in "$@" ; do
	case "$i" in
		"--remove"|"--disable"|"--enable")
			echo "Warning: Operation  $i is not supported by rlinetd's version of update-inetd" 1>&2
			;;
		"--version")
			echo "rlinetd's version of update-inetd"
			echo "version: $version"
			exit 0
			;;
		*)	if [ "x$last" = "x--add" ] ; then
				line="$i"
			fi
			;;
	esac

	last="$i"
done


if [ "x$last" = "x--add" ] ;then
	echo "Option --add requires an argument" 1>&2
	exit 1;
fi


if [ "x$line" != "x" ] ; then
	echo "$line" | inetd2rlinetd  /etc/rlinetd.d

	# reload configuration
	killall -HUP rlinetd || true
fi

if [ -f /etc/inetd.conf ] ; then
	real_upd=`dpkg-divert --truename /usr/sbin/update-inetd`
	[ -x "$real_upd" ] && "$real_upd" "$@"
fi
