## DNS support

rkt can automatically prepare `/etc/resolv.conf` for the apps in the pod. The simplest configuration is:

```bash
$ sudo rkt run --dns=8.8.8.8 pod.aci
```

Other parameters can be given:

```bash
$ sudo rkt run --dns=8.8.8.8 --dns=8.8.4.4 --dns-search=foo.com --dns-opt=debug pod.aci
```

This will generate the following `/etc/resolv.conf` for the applications:

```
# Generated by rkt

search foo.com
nameserver 8.8.8.8
nameserver 8.8.4.4
options debug
```

The following example shows that the DNS options allow the pod to resolve names successfully:

```sh
$ sudo rkt run --dns 8.8.8.8  --net=host kinvolk.io/aci/busybox:1.24 --exec /bin/busybox -- ping -c1 coreos.com
...
[57724.185917] busybox[4]: PING coreos.com (141.101.112.174): 56 data bytes
[57724.186222] busybox[4]: 64 bytes from 141.101.112.174: seq=0 ttl=55 time=22.394 ms
```
