# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Fixnum", "Integer", "class")
aClass.addFragment(Paragraph.new("A <code>Fixnum</code> holds <code>Integer</code> values that can be represented in a native machine word (minus 1 bit). If any operation on a <code>Fixnum</code> exceeds this range, the value is automatically converted to a <code>Bignum</code>.\n"))
aClass.addFragment(Paragraph.new("<code>Fixnum</code> objects have immediate value. This means that when they are assigned or passed as parameters, the actual object is passed, rather than a reference to that object. Assignment does not alias <code>Fixnum</code> objects. There is effectively only one <code>Fixnum</code> object instance for any given integer value, so, for example, you cannot add a singleton method to a <code>Fixnum</code>.\n"))
m0002 = MethodDesc.new("Arithmeticoperations", "instance", "<p></p>")
m0002.addFragment(Paragraph.new("Performs various arithmetic operations on <i>fix</i>.\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("Bitoperations", "instance", "<p></p>")
m0003.addFragment(Paragraph.new("Performs various operations on the binary representations of the <code>Fixnum</code>.\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("<=>", "instance", "<i>fix</i> <=> <i>aNumeric</i> -> -1, 0, +1")
m0004.addFragment(Paragraph.new("Comparison---Returns -1, 0, or +1 depending on whether <i>fix</i> is less than, equal to, or greater than <i>aNumeric</i>. This is the basis for the tests in <code>Comparable</code>.\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("[]", "instance", "<i>fix</i>[ <i>n</i> ] -> 0, 1")
m0005.addFragment(Paragraph.new("Bit Reference---Returns the <em>n</em>th bit in the binary representation of <i>fix</i>, where <i>fix</i>[0] is the least significant bit.\n"))
m0005.addFragment(Verbatim.new("a = 0b11001100101010\n30.downto(0) do |n| print a[n] end"))
m0005.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0005.addFragment(Verbatim.new("0000000000000000011001100101010"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("id2name", "instance", "<i>fix</i>.id2name -> <i>aString</i> or <code>nil</code>")
m0006.addFragment(Paragraph.new("Returns the name of the object whose symbol id is the value of <i>fix</i>. If there is no symbol in the symbol table with this value, returns <code>nil</code>. <code>id2name</code> has nothing to do with the <code>Object.id</code> method. See also <code>String\#intern</code> on page 376 and class <code>Symbol</code> on page 388.\n"))
m0006.addFragment(Verbatim.new("symbol = :@inst_var    \#=> :@inst_var\nid     = symbol.to_i   \#=> 8978\nid.id2name             \#=> \"@inst_var\"\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("size", "instance", "<i>fix</i>.size -> <i>aFixnum</i>")
m0007.addFragment(Paragraph.new("Returns the number of <em>bytes</em> in the machine representation of a <code>Fixnum</code>.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("to_f", "instance", "<i>fix</i>.to_f -> <i>aFloat</i>")
m0008.addFragment(Paragraph.new("Converts <i>fix</i> to a <code>Float</code>.\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("to_i", "instance", "<i>fix</i>.to_i -> <i>fix</i>")
m0009.addFragment(Paragraph.new("Returns <i>fix</i>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("to_s", "instance", "<i>fix</i>.to_s -> <i>aString</i>")
m0010.addFragment(Paragraph.new("Returns a string containing the decimal representation of self.\n"))
aClass.addMethod(m0010)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
