///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// direct solver UMFPACK, seq & dis implementations
//
// Note : why a dis implementation based on umfpack ?
//
// Because when dis_ext_nnz == 0, then the matrix is block diagonal.
// in that case the umfpack is better than mumps that initialize stuff
// for the distributed case.
// Is could appends e.g. for block-diagonal mass matrix "Pkd"
// This also occurs when nproc==1/
//
#include "solver_ldlt_builtin.h"

namespace rheolef {
using namespace std;

template<class T, class M>
solver_ldlt_builtin_rep<T,M>::solver_ldlt_builtin_rep ()
 : solver_abstract_rep<T,M>(solver_option()),
   _ldlt()
{
}
template<class T, class M>
solver_ldlt_builtin_rep<T,M>::solver_ldlt_builtin_rep (const csr<T,M>& a, const solver_option& opt)
 : solver_abstract_rep<T,M>(opt),
   _ldlt(a.data())
{
  check_macro (!_ldlt.is_singular(), "singular matrix");
}
template<class T, class M>
solver_ldlt_builtin_rep<T,M>::~solver_ldlt_builtin_rep ()
{
}
template<class T, class M>
void
solver_ldlt_builtin_rep<T,M>::update_values (const csr<T,M>& a)
{
  _ldlt.update_values (a.data());
  check_macro (!_ldlt.is_singular(), "singular matrix");
}
template<class T, class M>
vec<T,M>
solver_ldlt_builtin_rep<T,M>::solve (const vec<T,M>& b) const
{
  return _ldlt.solve (b);
}
template<class T, class M>
vec<T,M>
solver_ldlt_builtin_rep<T,M>::trans_solve (const vec<T,M>& b) const
{
  return _ldlt.solve (b);
}
template <class T, class M>
typename solver_ldlt_builtin_rep<T,M>::determinant_type
solver_ldlt_builtin_rep<T,M>::det() const
{
  warning_macro ("undefined computation of the determinant for the ldlt_buiiltin solver");
  return determinant_type();
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class solver_ldlt_builtin_rep<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class solver_ldlt_builtin_rep<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
