#include "rheolef.h"
#include "rheolef/mixed_solver.h"
using namespace rheolef;
using namespace std;
#include "embankment.h"
#include "pcg_solver.h"
int main(int argc, char**argv) {
  geo omega (argv[1]);
  Float inv_lambda = (argc > 2 ? atof(argv[2]) : 0);
  space Vh = embankment_space(omega, "P2");
  space Qh (omega, "P1");
  field uh (Vh,0.0), fh (Vh, 0.0);
  fh [omega.dimension()-1] = -1.0;
  field ph (Qh, 0.);
  form mu (Vh, Vh, "mass");
  form mp (Qh, Qh, "mass");
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  form c = inv_lambda*mp;
  int   max_iter  = 5000;
  Float tol       = 1e-15;
  if (omega.dimension() < 3) {
    int status = pcg_abtbc (a.uu, b.uu, c.uu, uh.u, ph.u, -(a.ub*uh.b) + (mu*fh).u,
        -(b.ub*uh.b), ldlt(mp.uu), ldlt(a.uu), max_iter, tol, &cerr);
  } else {
    int status = pcg_abtbc (a.uu, b.uu, c.uu, uh.u, ph.u, -(a.ub*uh.b) + (mu*fh).u,
        -(b.ub*uh.b), pcg_solver(mp.uu), pcg_solver(a.uu), max_iter, tol, &cerr);
  }
  cout << setprecision(numeric_limits<Float>::digits10)
       << catchmark("inv_lambda")  << inv_lambda << endl
       << catchmark("u")  << uh
       << catchmark("p")  << ph;
  return 0;
}
