// file automatically generated by "basis_symbolic_hermite_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "H3.h"
using namespace rheolef;
using namespace std;
class basis_H3_p {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_H3_e {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
basis_rep::dof_family_type
basis_H3_p::dof_family(
  size_type    i_dof_local)
{
  typedef basis_rep::dof_family_type T;
  T val = (basis_rep::dof_family_type)0;
  switch (i_dof_local) {
    case 0: {
      val = (basis_rep::dof_family_type)0;
      return val;
    }
    case 1: {
      val = (basis_rep::dof_family_type)1;
      return val;
    }
    default : {
      error_macro ("dof_family: invalid i_dof_local = " << i_dof_local);
      return element_constant::dof_family_max;
    }
  }
}
Float
basis_H3_p::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = 1.0; //mark
      return val;
    }
    case 1: {
      val = hat_x[0]; //mark
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_H3_p::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      return val;
    }
    case 1: {
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_H3_p::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  switch (i_dof_local) {
    case 0: {
      return val;
    }
    case 1: {
      return val;
    }
    default : {
      error_macro ("hessian_eval: invalid i_dof_local = " << i_dof_local);
      return val;
    }
  }
}
void
basis_H3_p::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(2);
  typedef Float T;
  values[0] = 1.0;
  values[1] = hat_x[0];
}
void
basis_H3_p::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(2);
  typedef Float T;
}
void
basis_H3_p::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(2,ini_val);
  typedef Float T;
}
void
basis_H3_p::hat_node(
  vector<point>& x)
{
  x.resize(2);
  x[0] = point();
  x[1] = point();
}
basis_rep::dof_family_type
basis_H3_e::dof_family(
  size_type    i_dof_local)
{
  typedef basis_rep::dof_family_type T;
  T val = (basis_rep::dof_family_type)0;
  switch (i_dof_local) {
    case 0: {
      val = (basis_rep::dof_family_type)0;
      return val;
    }
    case 1: {
      val = (basis_rep::dof_family_type)0;
      return val;
    }
    case 2: {
      val = (basis_rep::dof_family_type)1;
      return val;
    }
    case 3: {
      val = (basis_rep::dof_family_type)1;
      return val;
    }
    default : {
      error_macro ("dof_family: invalid i_dof_local = " << i_dof_local);
      return element_constant::dof_family_max;
    }
  }
}
Float
basis_H3_e::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  2.0*(hat_x[0]*hat_x[0]*hat_x[0])+-3.0*(hat_x[0]*hat_x[0])+1.0; //mark
      return val;
    }
    case 1: {
      val =  3.0*(hat_x[0]*hat_x[0])+-2.0*(hat_x[0]*hat_x[0]*hat_x[0]); //mark
      return val;
    }
    case 2: {
      val = -hat_x[0]-(hat_x[0]*hat_x[0]*hat_x[0])+2.0*(hat_x[0]*hat_x[0]); //mark
      return val;
    }
    case 3: {
      val = -(hat_x[0]*hat_x[0])+(hat_x[0]*hat_x[0]*hat_x[0]); //mark
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_H3_e::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  6.0*(hat_x[0]*hat_x[0])+-6.0*hat_x[0];
      return val;
    }
    case 1: {
      val[0] =  -6.0*(hat_x[0]*hat_x[0])+6.0*hat_x[0];
      return val;
    }
    case 2: {
      val[0] =  4.0*hat_x[0]+-3.0*(hat_x[0]*hat_x[0])-1.0;
      return val;
    }
    case 3: {
      val[0] =  3.0*(hat_x[0]*hat_x[0])+-2.0*hat_x[0];
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_H3_e::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  switch (i_dof_local) {
    case 0: {
      val(0,0) =  12.0*hat_x[0]-6.0;
      return val;
    }
    case 1: {
      val(0,0) =  -12.0*hat_x[0]+6.0;
      return val;
    }
    case 2: {
      val(0,0) =  -6.0*hat_x[0]+4.0;
      return val;
    }
    case 3: {
      val(0,0) =  6.0*hat_x[0]-2.0;
      return val;
    }
    default : {
      error_macro ("hessian_eval: invalid i_dof_local = " << i_dof_local);
      return val;
    }
  }
}
void
basis_H3_e::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(4);
  typedef Float T;
  values[0] =  2.0*(hat_x[0]*hat_x[0]*hat_x[0])+-3.0*(hat_x[0]*hat_x[0])+1.0;
  values[1] =  3.0*(hat_x[0]*hat_x[0])+-2.0*(hat_x[0]*hat_x[0]*hat_x[0]);
  values[2] = -hat_x[0]-(hat_x[0]*hat_x[0]*hat_x[0])+2.0*(hat_x[0]*hat_x[0]);
  values[3] =  (hat_x[0]*hat_x[0]*hat_x[0])-(hat_x[0]*hat_x[0]);
}
void
basis_H3_e::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(4);
  typedef Float T;
  values[0][0] =  -6.0*hat_x[0]+6.0*(hat_x[0]*hat_x[0]);
  values[1][0] =  6.0*hat_x[0]+-6.0*(hat_x[0]*hat_x[0]);
  values[2][0] =  4.0*hat_x[0]+-3.0*(hat_x[0]*hat_x[0])-1.0;
  values[3][0] =  -2.0*hat_x[0]+3.0*(hat_x[0]*hat_x[0]);
}
void
basis_H3_e::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(4,ini_val);
  typedef Float T;
  values[0](0,0) =  12.0*hat_x[0]-6.0;
  values[1](0,0) =  -12.0*hat_x[0]+6.0;
  values[2](0,0) =  -6.0*hat_x[0]+4.0;
  values[3](0,0) =  6.0*hat_x[0]-2.0;
}
void
basis_H3_e::hat_node(
  vector<point>& x)
{
  x.resize(4);
  x[0] = point(0.0);
  x[1] = point(1.0);
  x[2] = point(0.0);
  x[3] = point(1.0);
}
basis_H3::~basis_H3()
{
}
basis_H3::size_type
basis_H3::degree () const
{
    return 3;
}
basis_H3::size_type
basis_H3::size (
    reference_element hat_K, basis_rep::dof_family_type family) const
{
    if (family == element_constant::dof_family_max)
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 2;
      }
      case reference_element::e: {
        return 4;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
   else if (family == element_constant::Lagrange)
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 2;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
   else if (family == element_constant::Hermite)
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 2;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
   else {
      error_macro ("unrecognized family.");
    }
}
basis_rep::dof_family_type
basis_H3::dof_family(
    reference_element hat_K,
    size_type         i_dof_local) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::dof_family (i_dof_local);
      }
      case reference_element::e: {
      return basis_H3_e::dof_family (i_dof_local);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
        return element_constant::dof_family_max;
      }
    }
}
Float
basis_H3::eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_H3_e::eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
point
basis_H3::grad_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_H3_e::grad_eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
        return point();
      }
    }
}
tensor
basis_H3::hessian_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::hessian_eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_H3_e::hessian_eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("hessian_eval: unsupported `" << hat_K.name() << "' element type");
        return tensor(0.);
      }
    }
}
void
basis_H3::eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<Float>&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_H3_e::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_H3::grad_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<point>&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_H3_e::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_H3::hessian_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<tensor >&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::hessian_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_H3_e::hessian_eval (hat_x, values);
      }
      default : {
        error_macro ("hessian_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_H3::hat_node(
    reference_element hat_K,
    vector<point>&    hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_H3_p::hat_node (hat_node);
      }
      case reference_element::e: {
      return basis_H3_e::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
basis_rep* make_H3(void) { return new_macro(basis_H3); }
