#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "cosinusprod_laplace.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  size_t d = omega.dimension();
  size_t k = Xh.degree();
  Float beta = (k+1)*(k+d)/d;
  trial u (Xh); test v (Xh);
  form  a = integrate (dot(grad_h(u),grad_h(v)))
          + integrate (omega.sides(), 
                  beta*penalty()*jump(u)*jump(v)
	 	- jump(u)*average(dot(grad_h(v),normal()))
	 	- jump(v)*average(dot(grad_h(u),normal())));
  field lh = integrate (f(d)*v)
           + integrate (omega.boundary(),
                  beta*penalty()*g(d)*jump(v)
	 	- g(d)*average(dot(grad_h(v),normal())));
  solver sa (a.uu());
  field uh(Xh);
  uh.set_u() = sa.solve(lh.u());
  dout << uh;
}
