///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/lumped_mass.h"

namespace rheolef {
using namespace std;
using namespace ublas;

// TODO : force trapeze quadrature formulae when using non-constant weight
// because quadrature formulae degree is automatically computed
// for an exact approximation !!
// Actually, the lumped weighted matrix does not coincide with
// the local mass matrix with trapeze quadrature formulae

template<class T, class M>
void 
lumped_mass<T,M>::operator() (const geo_element& K, ublas::matrix<T>& lumped_m) const
{
  base::build_general_mass (K, lumped_m);
  check_macro (lumped_m.size1() == lumped_m.size2(),
	"lumped_mass: incompatible `" << base::get_first_basis().name()
	<< "' and `" << base::get_second_basis().name() << "' basis");
  size_type n = lumped_m.size1();
  for (size_type i = 0; i < n; i++) {
    T s = 0;
    for (size_type j = 0; j < n; j++) {
      if (i != j) {
	s += lumped_m(i,j);
	lumped_m(i,j) = 0;
      }
    }
    lumped_m (i,i) += s;
  }
}
template<class T, class M>
void
lumped_mass<T,M>::initialize () const
{
  check_macro (base::get_first_space().size() == base::get_second_space().size(),
    "incompatible spaces for the `lumped_mass' form.");
  check_macro (base::get_first_basis().name() == base::get_second_basis().name(),
    "incompatible approximations for the `lumped_mass' form.");
  std::string approx = base::get_first_basis().name();
  check_macro ("P0" == approx || "P1" == approx || "P1d" == approx,
	"unsupported `"<<approx<<"' approximation space for `lumped_mass' form");
  if (base::is_weighted()) {
      space_constant::valued_type weight_valued = base::_wh.valued_tag();
      check_macro (weight_valued == space_constant::scalar,
	"unsupported non-scalar weight for `lumped_mass' form");
  }
  base::set_n_derivative(0);
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class lumped_mass<Float,sequential>;
#ifdef _RHEOLEF_HAVE_MPI
template class lumped_mass<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
