set terminal epslatex color standalone
set output "p-laplacian-square-p=1,2-cut.tex"

set size square 

set xtics ("[c]{$-\\sqrt{2}$}" -1, 0, "[c]{$\\sqrt{2}$}" 1)
set ytics (0, \
	'[r]{$10^{-5}$}'         1e-5, \
	'[r]{$2\times 10^{-5}$}' 2e-5, \
	'[r]{$3\times 10^{-5}$}' 3e-5)
set xlabel "[c]{$s=\\sqrt{x_0^2+x_1^2}$}
set  label "[l]{$u_h(x_0,x_1)$}" at graph 0.05,0.9

plot  [-1:1][0:3e-5] "p-laplacian-square-p=1,2-cut.gdat" notitle w l lt 1 lw 2

