#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "poiseuille.h"
int main (int argc, char** argv) {
  environment rheolef (argc, argv);
  field uh;
  din >> uh;
  const geo& omega = uh.get_geo();
  string sys_coord = omega.coordinate_system_name();
  Float c = omega.xmax()[1];
  string approx = "P" + itos(uh.get_space().degree());
  space Ph (omega, approx);
  Ph.block("upstream");
  Ph.block("wall");
  Ph.block("axis");
  space Wh (omega["upstream"], approx);
  const space& Xh = uh.get_space();
  form a (Ph, Ph, "s_grad_grad");
  form b (Ph, Xh, "s_curl");
  field psi_h (Ph, 0);
  psi_h["upstream"] = interpolate (Wh, psi(c,sys_coord));
  psi_h["wall"] = 0;
  psi_h["axis"] = -1;
  field lh = b.trans_mult(uh);
  solver sa (a.uu());
  psi_h.set_u() = sa.solve (lh.u() - a.ub()*psi_h.b());
  dout << catchmark("psi") << psi_h;
}
