#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "sphere.icc"
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  geo lambda (argv[1]);
  space Xh (lambda, "P1");
  field phi_h = interpolate(Xh, phi);
  band gh (phi_h);
  space Bh (gh.band(), "P1");
  form m (Bh, Bh, "mass",      gh);
  form a (Bh, Bh, "grad_grad", gh);
  a = m+a;
  size_t d = lambda.dimension();
  field lh = riesz (Bh, f(d), gh);
  field uh (Bh,0);
  size_t max_iter = 10000;
  Float tol = 1e-10;
  pminres (a.uu(), uh.set_u(), lh.u(), eye(), max_iter, tol, &derr);
  gh.band().save();
  dout << catchmark("u")   << uh 
       << catchmark("phi") << phi_h;
}
