///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// direct solver interface
//
#include "rheolef/solver.h"
#include "solver_pastix.h"

namespace rheolef {

template<class T, class M>
solver_rep<T,M>::solver_rep (const csr<T,M>& a, const solver_option_type& opt)
 : _ptr(new_macro(rep(a,opt)))
{
}
template<class T, class M>
solver_rep<T,M>::~solver_rep ()
{
  delete_macro (_ptr);
}
template<class T, class M>
void 
solver_rep<T,M>::update_values (const csr<T,M>& a)
{
  _ptr->update_values (a);
}
template<class T, class M>
vec<T,M>
solver_rep<T,M>::solve (const vec<T,M>& b)
{
  return _ptr->solve (b);
}
template<class T, class M>
vec<T,M>
solver_rep<T,M>::trans_solve (const vec<T,M>& b)
{
  return _ptr->trans_solve (b);
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class solver_rep<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class solver_rep<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
