///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// check field_indirect with field rhs
#include "rheolef.h"
#include "rounder.h"
using namespace rheolef;
using namespace std;
size_t N;
Float f (const point& x) { return 1+(0.5/N)*(x[0]*(1-x[0])+x[1]*(1-x[1])+x[2]*(1-x[2])); }
Float g (const point& x) { 
  warning_macro ("g("<<x<<")...");
  return -1-(x[0]+x[1]+x[2]);
}
int main(int argc, char**argv) {
  environment distributed(argc, argv);
  geo omega (argv[1]);
  Float prec = (argc > 2) ? atof(argv[2]) : 1e-10;
  space Vh (omega, "P1");
  space Wh (omega["left"], "P1");
  N = omega.dimension();
  field fh = interpolate(Vh, f);
  field gh = interpolate(Wh, g);
  fh["left"] = gh;
  dcout << setprecision(15) << compose(rounder(prec),fh);
}
