#ifndef _RHEOLEF_POINT_SERIALIZE_H
#define _RHEOLEF_POINT_SERIALIZE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================

#include "rheolef/basic_point.h"
#include "rheolef/distributed.h"

#ifdef _RHEOLEF_HAVE_MPI
namespace boost {
 namespace serialization {
  template<class Archive, class T>
  void serialize (Archive& ar, class rheolef::basic_point<T>& x, const unsigned int version) {
    ar & x[0];
    ar & x[1];
    ar & x[2];
  }
 } // namespace serialization
} // namespace boost

// Some serializable types, like geo_element, have a fixed amount of data stored at fixed field positions.
// When this is the case, boost::mpi can optimize their serialization and transmission to avoid extraneous copy operations.
// To enable this optimization, we specialize the type trait is_mpi_datatype, e.g.:
namespace boost {
 namespace mpi {
  // TODO: when basic_point<T> is not a simple type, such as T=doubledouble or T=gmp, etc
  template <>
  struct is_mpi_datatype<rheolef::basic_point<double> > : mpl::true_ { };
 } // namespace mpi
} // namespace boost
#endif // _RHEOLEF_HAVE_MPI

#endif // _RHEOLEF_POINT_SERIALIZE_H
