// robust floating point predicates: specialization for double

#include "rheolef/basic_point.h"
#include "predicates.h"
using namespace rheolef;

namespace rheolef {
static
void
init_orient ()
{
  static bool has_init = false;
  if (has_init) return;
  has_init = true;
  trace_macro ("exactinit");
  exactinit();
}
template<>
double
orient2d (const basic_point<double>& a, const basic_point<double>& b,
	 const basic_point<double>& c)
{
  init_orient();
  trace_macro ("orient2d");
  return orient2d ((double*)a._x, (double*)b._x, (double*)c._x);
}
template<>
double
orient3d (const basic_point<double>& a, const basic_point<double>& b,
	  const basic_point<double>& c, const basic_point<double>& d)
{
  init_orient();
  trace_macro ("orient3d");
  return orient3d ((double*)a._x, (double*)b._x, (double*)c._x, (double*)d._x);
}
} // namespace rheolef
