///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// Tests de map::iterator vue de la classe polymorphic_array
//
//  => - conversion de map::iterator en void* et reciproquement
//     - insertion/suppression d'un element, eventuellement de type
//       derive different
//
// Author: Pierre.Saramito@imag.fr
//
// Date: 14 dec 2010
//

#include "geo_element_tst.h"
using namespace rheolef;

#include <map>
#include <iostream>
using namespace std;

template <class T>
void show (const map<size_t,T>& a) {
  for (typename map<size_t,T>::const_iterator iter = a.begin(), last = a.end(); iter != last; iter++) {
    cout << (*iter).first << " " << (*iter).second << endl;
  }
}
// transform a map::iterator into a void*
template <class Tk>
void*
to_pointer (typename map<size_t,Tk>::iterator iter_tk)
{
  return static_cast<void*>(iter_tk._M_node);
}
// transform a void* into a map::iterator
template <class Tk>
typename map<size_t,Tk>::iterator
to_iterator (void* ptr)
{
  typedef typename map<size_t,Tk>::iterator iterator;
  typedef typename iterator::_Link_type link_type;
  return iterator (static_cast<link_type>(ptr));
}
// ---------------------------------------------------------------------------
// print the data structure: convert void* into map::iterator
// ---------------------------------------------------------------------------
void
print (ostream& os, vector<pair<size_t,void*> >& table) {
  os << "geo " << table.size() << endl;
  for (size_t i = 0; i < table.size(); i++) {
    switch (table[i].first) {
      case 0 : {
	map<size_t,geo_element_t>::iterator iter = to_iterator<geo_element_t>(table[i].second);
        os << (*iter).second << endl;
        break;
      }
      case 1 : {
	map<size_t,geo_element_q>::iterator iter = to_iterator<geo_element_q>(table[i].second);
        os << (*iter).second << endl;
        break;
      }
      default :{
	cerr << "unexpected variant " << table[i].first <<  endl;
        exit (1);
      }
    }
  }
}
int main () {
  // ---------------------------------------------------------------------------
  // creation of the data structure: convert map::iterator into void*
  // ---------------------------------------------------------------------------
  // triangles:
  map<size_t,geo_element_t> t;
  t.insert (pair<size_t,geo_element_t>(0,geo_element_t(1,2,3)));
  t.insert (pair<size_t,geo_element_t>(1,geo_element_t(21,22,23))); // will be deleted
  t.insert (pair<size_t,geo_element_t>(2,geo_element_t(4,5,6)));
  t.insert (pair<size_t,geo_element_t>(4,geo_element_t(7,8,9)));
#ifdef TO_CLEAN
  cout << "t = " << endl; show (t);
#endif // TO_CLEAN

  // quadrangles:
  map<size_t,geo_element_q> q;
  //q.insert (pair<size_t,geo_element_q>(1,geo_element_q(11,12,13,14))); // will be created
  q.insert (pair<size_t,geo_element_q>(3,geo_element_q(15,16,17,18)));
#ifdef TO_CLEAN
  cout << "q = " << endl; show (q);
#endif // TO_CLEAN

  // test iterators
  cerr << "sizeof(void*) = "
       << sizeof(void*) << endl;
  cerr << "sizeof(map<size_t,geo_element_t>::iterator) = "
       << sizeof(map<size_t,geo_element_t>::iterator) << endl;

  // transform a map::iterator into a void*
  map<size_t,geo_element_t>::iterator it0 = t.begin();
  typedef map<size_t,geo_element_t>::iterator::_Link_type link_t_type;
  link_t_type link_t = static_cast<link_t_type>(it0._M_node);

  // typedef map<size_t,geo_element>::iterator::_Link_type link_type; // ERROR: pure virtual..
  typedef void* link_type; // ERROR: pure virtual..
  link_type link = static_cast<link_type>(link_t);

  // transform a void* into a map::iterator
  link_t_type link_t2 = static_cast<link_t_type>(link);
  map<size_t,geo_element_t>::iterator it2 (link_t2);

  // table of pointers
  vector<pair<size_t,void*> > table (5);
  map<size_t,geo_element_t>::iterator it = t.begin();
  map<size_t,geo_element_q>::iterator iq = q.begin();
  table[0] = make_pair(0, to_pointer<geo_element_t>(it++));
  table[1] = make_pair(0, to_pointer<geo_element_t>(it++));
  table[2] = make_pair(0, to_pointer<geo_element_t>(it++));
  table[3] = make_pair(1, to_pointer<geo_element_q>(iq++));
  table[4] = make_pair(0, to_pointer<geo_element_t>(it++));

#ifdef TO_CLEAN
  print (cout, table);
#endif // TO_CLEAN

// ---------------------------------------------------------------------------
// replace into the data structure: convert void* into map::iterator
// ---------------------------------------------------------------------------
  // replace an element: when variants are different
  // input: pos, value
  // - ptr2iter 
  // - save its index
  // - delete from orig map
  // - insert in dest map with index
warning_macro ("ici [0]");
  vector<pair<size_t,void*> >::iterator pos = table.begin();
warning_macro ("ici [1]");
  pos++; // points to index 1
  geo_element_q value (11,12,13,14);
  map<size_t,geo_element_t>::iterator iter_old = to_iterator<geo_element_t>((*pos).second);
  size_t index = (*iter_old).first;
  t.erase (iter_old);
warning_macro ("ici [2] index="<<index);

  pair<map<size_t,geo_element_q>::iterator, bool> status 
    = q.insert (pair<size_t,geo_element_q>(index,value));

  map<size_t,geo_element_q>::iterator iter_new = status.first;

  *pos = make_pair(1, to_pointer<geo_element_q>(iter_new));
warning_macro ("ici [3]");
  print (cout, table);
}
