///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
# include "rheolef/csr.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv)
{
    environment parallel(argc, argv);

    unsigned int nrow;
    unsigned int ncol;
    pcin >> nrow >> ncol;
    asr<Float> a1(nrow, ncol);
    pcin >> a1;

    csr<Float> a(a1);

    vec<Float> x (a.col_ownership(), 1.0);
    vec<Float> y (a.row_ownership(), 1e+38);
    a.mult(x, y);

    pcout << y.par_size() << endl
          << y            << endl;
}
