// robust floating point predicates: specialization for double

#include "rheolef/basic_point.h"
#include "predicates.h"
using namespace rheolef;

namespace rheolef {
static
void
init_orient ()
{
  static bool has_init = false;
  if (has_init) return;
  has_init = true;
  trace_macro ("exactinit");
  exactinit();
}
template<>
double
orient2d (const basic_point<double>& a, const basic_point<double>& b,
	 const basic_point<double>& c)
{
  init_orient();
  trace_macro ("orient2d");
  return orient2d ((double*)a.x_, (double*)b.x_, (double*)c.x_);
}
template<>
double
orient3d (const basic_point<double>& a, const basic_point<double>& b,
	  const basic_point<double>& c, const basic_point<double>& d)
{
  init_orient();
  trace_macro ("orient3d");
  return orient3d ((double*)a.x_, (double*)b.x_, (double*)c.x_, (double*)d.x_);
}
} // namespace rheolef
