# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Handles background errors not handled by the backend error handler
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package provide bugHandler 1.0

proc bgerror { errorMessage } {
    global applicationName
    global placeToReportBugs
    global bughandler env errorInfo

    if { [winfo exists .errorBox] } {
	return
    }

    set stackTrace $errorInfo

    toplevel .errorBox
    
    wm withdraw .errorBox

    # Disable the main program window

    wm transient .errorBox .

    wm title .errorBox "An unexpected error has occurred."

    wm protocol .errorBox WM_DELETE_WINDOW hideErrorHandlerWindow

    label .errorBox.description -text "An unexpected error has occurred in ${applicationName}." -justify left 
    label .errorBox.placeToReport -text "$placeToReportBugs" -justify left

    label .errorBox.traceBackCaption -text "Error traceback:"

    iwidgets::scrolledtext .errorBox.traceBack \
	    -hscrollmode dynamic \
	    -vscrollmode dynamic \
	    -state disabled

    .errorBox.traceBack configure -state normal
    .errorBox.traceBack insert end "$errorInfo"
    .errorBox.traceBack configure -state disabled

    label .errorBox.reportingInstructions -text "Please include the error traceback and a description of the events leading up to the error when filing your bug report."

    button .errorBox.okButton -text "OK" -underline 0 -command hideErrorHandlerWindow

    bind .errorBox <Alt-o> {hideErrorHandlerWindow; break}
    bind .errorBox <Escape> {hideErrorHandlerWindow; break}
    bind .errorBox <Return> {hideErrorHandlerWindow; break}

    pack .errorBox.description -side top -fill x 
    pack .errorBox.placeToReport -side top -fill x
    pack .errorBox.traceBackCaption -side top -fill x
    pack .errorBox.traceBack -side top -fill x
    pack .errorBox.reportingInstructions -side top -fill x 
    pack .errorBox.okButton -side top

    # Release the grab so that the user can hit the okay button the error 
    # box/scroll through the trace.

    if {[string compare [grab current .] ""]} {
        grab release [grab current .]
    }

    wm deiconify .errorBox
}

proc hideErrorHandlerWindow {} {
    wm withdraw .errorBox
    releaseLockFile
    destroy .
}


# End of file
