/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "OXViewerApplet.h"

#include "OXAbout.h"
#include "OXConnectionOptions.h"
#include "OXConnectionDetails.h"

#include <iostream>

#include <sys/types.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "../icons/rfb_viewer_large.xpm"
#include "../icons/viewerInactive16x16.xpm"
#include "../icons/viewerInactive32x32.xpm"
#include "../icons/viewerInactive40x40.xpm"

#include "../icons/digit.0.xpm"
#include "../icons/digit.1.xpm"
#include "../icons/digit.2.xpm"
#include "../icons/digit.3.xpm"
#include "../icons/digit.4.xpm"
#include "../icons/digit.5.xpm"
#include "../icons/digit.6.xpm"
#include "../icons/digit.7.xpm"
#include "../icons/digit.8.xpm"
#include "../icons/digit.9.xpm"
#include "../icons/digit.colon.xpm"
#include "../icons/digit.minus.xpm"


#include "version.h"



void createViewerProcess( rfb::ConnectionInfo &connectionInfo, int fd0, int fd1 );

OXViewerApplet::OXViewerApplet( OXClient *_client, const char *_xrfbviewerCommand )
  : OXMainFrame( _client->GetRoot(), 40, 40 )
{
  xrfbviewerCommand = (char*) malloc( strlen( _xrfbviewerCommand ) + 1 );
  strcpy( xrfbviewerCommand, _xrfbviewerCommand );

  sock = socket( PF_INET, SOCK_STREAM, 0 );
  if ( sock < 0 ) {
    delete this;
    return;
  }

  int one = 1;
  setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(one));

  int port = atoi( strstr( DisplayString(_client->GetDisplay()), ":" ) + 1 ) + 5499;

  struct sockaddr_in name;
  do {
      port++;
      name.sin_family = AF_INET;
      name.sin_port = htons( port );
      name.sin_addr.s_addr = htonl (INADDR_ANY);
  } while ( bind (sock, (struct sockaddr *) &name, sizeof (name) ) );

  if ( listen(sock, 5) ) {
    delete this;
    return;
  }

  port = (port < 5600)? port - 5500 : port;

  SetWindowName( "xrfbviewer applet" );
  SetIconName( "xrfbviewer applet" );
  SetClassHints( "applet", "xrfbviewer" );
  AddInput( ButtonPressMask | ButtonReleaseMask );

  popupMenu = new OXPopupMenu( _client->GetRoot() );
  popupMenu->AddEntry( new OHotString( "New Connection" ), 100 );
  popupMenu->AddEntry( new OHotString( "Default connection options..." ), 101 );
  popupMenu->AddSeparator();
  popupMenu->AddEntry( new OHotString( "About xrfbviewer" ), 102 );
  popupMenu->AddSeparator();
  popupMenu->AddEntry( new OHotString( "Close listening daemon" ), 103 );


  popupMenu->SetDefaultEntry( 100 );
  popupMenu->Associate( this );


  OXCompositeFrame *frameApplet = new OXCompositeFrame( this, 40, 40, VERTICAL_FRAME );


  iconViewer = new OXIcon( frameApplet, _client->GetPicture( "viewerInactive40x40_xpm", viewerInactive40x40_xpm ), 40, 40 );

  frameDisplay = new OXCompositeFrame( frameApplet, 16, 16, HORIZONTAL_FRAME );
  OLayoutHints *lh_sign = new OLayoutHints( LHINTS_BOTTOM | LHINTS_LEFT, 0, 0, 0, 0 );
  OLayoutHints *lh_digit = new OLayoutHints( LHINTS_BOTTOM | LHINTS_RIGHT, 0, 0, 0, 0 );

  
  OXIcon *colon = new OXIcon( frameDisplay, _client->GetPicture( "digit_colon", digit_colon_xpm ), 6, 9 );
  frameDisplay->AddFrame( colon, lh_sign );
  
  int display = port;
  if ( port < 0 ) {
      OXIcon *minus = new OXIcon( frameDisplay, _client->GetPicture( "digit_minus", digit_minus_xpm ), 6, 9 );
      frameDisplay->AddFrame( minus, lh_sign );
      port = 0 - port;
  }
  
  if ( port == 0 ) {
      OXIcon *digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_0", digit_0_xpm ), 6, 9 );
      frameDisplay->AddFrame( digit, lh_digit );
  } else {
      while ( port ) {
          OXIcon *digit = NULL;
          switch ( port % 10 ) {
              case 0: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_0", digit_0_xpm ), 6, 9 ); break;
              case 1: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_1", digit_1_xpm ), 6, 9 ); break;
              case 2: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_2", digit_2_xpm ), 6, 9 ); break;
              case 3: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_3", digit_3_xpm ), 6, 9 ); break;
              case 4: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_4", digit_4_xpm ), 6, 9 ); break;
              case 5: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_5", digit_5_xpm ), 6, 9 ); break;
              case 6: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_6", digit_6_xpm ), 6, 9 ); break;
              case 7: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_7", digit_7_xpm ), 6, 9 ); break;
              case 8: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_8", digit_8_xpm ), 6, 9 ); break;
              case 9: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_9", digit_9_xpm ), 6, 9 ); break;
	      default: break;
	  }
          frameDisplay->AddFrame( digit, lh_digit );
	  port /= 10;
      }
  }


  layoutHints[iconViewer] = new OLayoutHints( LHINTS_CENTER_X | LHINTS_TOP, 0, 0, 0, 0 );
  frameApplet->AddFrame( iconViewer, layoutHints[iconViewer] );


  layoutHints[frameDisplay] = new OLayoutHints( LHINTS_RIGHT | LHINTS_TOP, 0, 2, -11, 2 );
  frameApplet->AddFrame( frameDisplay, layoutHints[frameDisplay] );

  layoutHints[frameApplet] = new OLayoutHints( LHINTS_CENTER_X | LHINTS_CENTER_Y, 0, 0, 0, 0 );
  AddFrame( frameApplet, layoutHints[frameApplet] );
  
  Layout();
  
  char tip[256];
  sprintf( tip, "xrfbviewer listening\non display :%i", display );
  iconViewer->SetTip( tip );

  MapSubwindows();
  MapWindow();

  fhSocket = new OFileHandler( this, sock, XCM_READABLE | XCM_EXCEPTION );

  _client->Run();
}


OXViewerApplet::~OXViewerApplet()
{
  while ( layoutHints.begin() != layoutHints.end() ) {
    delete layoutHints.begin()->second;
    layoutHints.erase( layoutHints.begin() );
  }

  delete popupMenu;
}



int OXViewerApplet::HandleFileEvent( OFileHandler *_fh, unsigned int _mask )
{
  if ( _fh == fhSocket ) {
    cout << "Connection request" << endl;
    struct sockaddr addr;
    size_t laddr = sizeof(addr);
    int fdClient = accept(_fh->GetFd(), &addr, &laddr);
    int one = 1;
    setsockopt(fdClient, IPPROTO_TCP, TCP_NODELAY, (char *)&one, sizeof(one));
    fcntl(fdClient, F_SETFL, O_NONBLOCK);
    createViewerProcess( connectionInfo, fdClient, fdClient );    
    return true;
  } else
  return false;
}


void OXViewerApplet::Layout()
{
  if ( ( _w < 32 ) || ( _h < 32 ) ) {
    iconViewer->SetPicture( _client->GetPicture( "viewerInactive16x16_xpm",
                                                  viewerInactive16x16_xpm ) );
    frameDisplay->UnmapWindow();
  }
  else
  if ( ( _w < 40 ) || ( _h < 40 ) ) {
    iconViewer->SetPicture( _client->GetPicture( "viewerInactive32x32_xpm",
                                                  viewerInactive32x32_xpm ) );
    frameDisplay->UnmapWindow();
  }
  else {
    iconViewer->SetPicture( _client->GetPicture( "viewerInactive40x40_xpm",
                                                  viewerInactive40x40_xpm ) );
    frameDisplay->MapWindow();
  }
  OXMainFrame::Layout();
}


int OXViewerApplet::HandleButton(XButtonEvent * event)
{
  if ( event->type == ButtonRelease ) {
    if ( event->button == 3 ) {
      popupMenu->PlaceMenu( event->x_root - popupMenu->GetWidth(), event->y_root, false, true );
    }
  }
  return True;
}


int OXViewerApplet::ProcessMessage( OMessage *msg )
{
  OWidgetMessage *wmsg = (OWidgetMessage *) msg;

  switch (msg->type) {
    case MSG_MENU:
      switch(msg->action) {
        case MSG_CLICK:
          switch(wmsg->id) {

            case 100: {
              cout << "new connection" << endl;
              char tmp[1024];
              cout << xrfbviewerCommand << endl;
              sprintf( tmp, "exec %s &", xrfbviewerCommand );
              system( tmp );
              return true;
            }

            case 101:
              cout << "connection options" << endl;
              getConnectionOptions( connectionInfo, _client->GetRoot(), this );              
              return true;

            case 102: {
              cout << "about" << endl;
              OXAbout *about = new OXAbout( _client->GetRoot(),
	                                    this,
					    "About: heXoNet xrfbviewer V" VERSION_xrfbviewer,
					    "xrfbviewer version " VERSION_xrfbviewer,
					    "The RFB viewer from heXoNet",
					    _client->GetPicture( "rfb_viewer_large", rfb_viewer_large_xpm )
					  );
              about->MapWindow();
              return true;
            }

            case 103:
              cout << "close" << endl;
              delete this;
              return true;
          }
      }
  }

  return false;
}



