/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "OXButtonBox.h"

#include <xclass/OXIcon.h>
#include <xclass/OPicture.h>

#include "../icons/top2.xpm"
#include "../icons/top2_hexonet.xpm"
#include "../icons/right2.xpm"


OXButtonBox::OXButtonBox( OXFrame *parent, int distance )
  : OXCompositeFrame( parent, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH )
{
    const OPicture *back = _client->GetPicture( "top", top2_xpm );
    SetBackgroundPixmap( back->GetPicture() );
    const OPicture *left = _client->GetPicture( "top_hexonet", top2_hexonet_xpm );
    OXIcon *iconLeft = new OXIcon( this, left, left->GetWidth(), left->GetHeight() );
    lhIconLeft = new OLayoutHints( LHINTS_BOTTOM | LHINTS_LEFT, 0, distance, 0, 0 );
    AddFrame( iconLeft, lhIconLeft );
    const OPicture *right = _client->GetPicture( "right", right2_xpm );
    OXIcon *iconRight = new OXIcon( this, right, right->GetWidth(), right->GetHeight() );
    lhIconRight = new OLayoutHints( LHINTS_BOTTOM | LHINTS_RIGHT, 0, 0, 0, 0 );
    AddFrame( iconRight, lhIconRight );
    MapSubwindows();
}



OXButtonBox::~OXButtonBox()
{
  delete lhIconRight;
  delete lhIconLeft;
}


