#include "ZlibConnection.h"
#include <stdlib.h>
#include <zlib.h>


ZlibConnection::ZlibConnection()
  : BufferedConnection( 8192, 8192 )
  , zstreamSender( NULL )
  , zstreamReceiver( NULL )
{}


ZlibConnection::~ZlibConnection()
{
  if ( zstreamSender ) delete (z_stream*) zstreamSender;
  if ( zstreamReceiver ) delete (z_stream*) zstreamReceiver;
}

int ZlibConnection::send( unsigned char* _data, unsigned int _size )
{
  if ( zstreamSender ) {
    zstreamSender->next_in = _data;
    zstreamSender->avail_in = _size;
    int bufferSize = _size + 1024;
    unsigned char tmp[bufferSize];
    while ( zstreamSender->avail_in ) {
      zstreamSender->next_out = tmp;
      zstreamSender->avail_out = bufferSize;
      deflate( zstreamSender, Z_SYNC_FLUSH );
      BufferedConnection::send( tmp, bufferSize - zstreamSender->avail_out );
    }
    return _size;
  }
  else
    return BufferedConnection::send( _data, _size );
}

int ZlibConnection::receive( unsigned char* _data, unsigned int _size )
{
  if ( zstreamReceiver ) {
    zstreamReceiver->next_in = receiverBuffer.data + receiverBuffer.pos;
    zstreamReceiver->avail_in = receiverBuffer.end - receiverBuffer.pos;
    zstreamReceiver->next_out = _data;
    zstreamReceiver->avail_out = _size;
    inflate( zstreamReceiver, Z_SYNC_FLUSH );
    receiverBuffer.pos = receiverBuffer.end - zstreamReceiver->avail_in;
    return _size - zstreamReceiver->avail_out;
  } else
    return BufferedConnection::receive( _data, _size );
}


bool ZlibConnection::isAlive()
{
  return true;
}

void ZlibConnection::enableSenderDeflation( int level )
{
  if ( zstreamSender ) return;
  zstreamSender = new z_stream;
  zstreamSender->next_in = Z_NULL;
  zstreamSender->avail_in = 0;
  zstreamSender->zalloc = Z_NULL;
  zstreamSender->zfree = Z_NULL;
  zstreamSender->opaque = NULL;
  deflateInit( zstreamSender, level );
}

void ZlibConnection::enableReceiverInflation()
{
  if ( zstreamReceiver ) return;
  zstreamReceiver = new z_stream;
  zstreamReceiver->next_in = Z_NULL;
  zstreamReceiver->avail_in = 0;
  zstreamReceiver->zalloc = Z_NULL;
  zstreamReceiver->zfree = Z_NULL;
  zstreamReceiver->opaque = NULL;
  inflateInit( zstreamReceiver );
}

