/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#ifndef _hexonet_Framebuffer_h_
#define _hexonet_Framebuffer_h_


#include "rfb.h"

namespace rfb {


class Framebuffer
{
  public:

    virtual void update( unsigned int _x,
                         unsigned int _y,
               		 unsigned int _w,
		         unsigned int _h
	               );

    virtual void copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY
                         );
                         
    virtual void fillRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           CARD32 &pixelValue
                         );

                         
    void getPixel( unsigned int x,
                   unsigned int y,
                   unsigned int &r,
                   unsigned int &g,
                   unsigned int &b,
                   unsigned int m = 255 ) {
        unsigned char *src = data + y * bytesPerLine;
        unsigned int red_max =     pixelFormat.red_max;
        unsigned int green_max =   pixelFormat.green_max;
        unsigned int blue_max =    pixelFormat.blue_max;
        unsigned int red_shift =   pixelFormat.red_shift;
        unsigned int green_shift = pixelFormat.green_shift;
        unsigned int blue_shift =  pixelFormat.blue_shift;
        unsigned int value = 0;
        switch (pixelFormat.bits_per_pixel) {
            case 8: {
                value = src[x];
            }; break;
            case 16: {
                if ( pixelFormat.big_endian_flag )
                    value = (src[x*2+0] << 8) | src[x*2+1];
                else
                    value = (src[x*2+1] << 8) | src[x*2+0];
            }; break;
            case 24: {
                if ( pixelFormat.big_endian_flag )
                    value = (src[x*3+0] << 16) | (src[x*3+1] << 8) | src[x*3+2];
                else
                    value = (src[x*3+2] << 16) | (src[x*3+1] << 8) | src[x*3+0];
            }; break;
            case 32: {
                if ( pixelFormat.big_endian_flag )
                    value = (src[x*4+0] << 24) | (src[x*4+1] << 16) | (src[x*4+2] << 8) | src[x*4+3];
                else
                    value = (src[x*4+3] << 24) | (src[x*4+2] << 16) | (src[x*4+1] << 8) | src[x*4+0];
            }; break;
            default: break;
        }
        r = ((value >> red_shift)   & red_max)   * m / red_max;
        g = ((value >> green_shift) & green_max) * m / green_max;
        b = ((value >> blue_shift)  & blue_max)  * m / blue_max;
    }
                         
    void putPixel( unsigned int x,
                   unsigned int y,
                   unsigned int r,
                   unsigned int g,
                   unsigned int b,
                   unsigned int m = 255 ) {
        unsigned char *src = data + y * bytesPerLine;
        unsigned int r_max =   pixelFormat.red_max;
        unsigned int g_max =   pixelFormat.green_max;
        unsigned int b_max =   pixelFormat.blue_max;
        unsigned int r_shift = pixelFormat.red_shift;
        unsigned int g_shift = pixelFormat.green_shift;
        unsigned int b_shift = pixelFormat.blue_shift;
        r = (r * r_max / m);
        g = (g * g_max / m);
        b = (b * b_max / m);
        if ( r > r_max ) r = r_max;
        if ( g > g_max ) g = g_max;
        if ( b > b_max ) b = b_max;
        r <<= r_shift;
        g <<= g_shift;
        b <<= b_shift;
        unsigned int value = r | g | b;
        switch (pixelFormat.bits_per_pixel) {
            case 8: {
                src[x] = value;
            }; break;
            case 16: {
                if ( pixelFormat.big_endian_flag ) {
                    src[x*2+0] = value >> 8;
                    src[x*2+1] = value;
                }
                else {
                    src[x*2+1] = value >> 8;
                    src[x*2+0] = value;
                }
            }; break;
            case 24: {
                if ( pixelFormat.big_endian_flag ) {
                    src[x*3+0] = value >> 16;
                    src[x*3+1] = value >> 8;
                    src[x*3+2] = value;
                }
                else {
                    src[x*3+2] = value >> 16;
                    src[x*3+1] = value >> 8;
                    src[x*3+0] = value;
                }
            }; break;
            case 32: {
                if ( pixelFormat.big_endian_flag ) {
                    src[x*4+0] = value >> 24;
                    src[x*4+1] = value >> 16;
                    src[x*4+2] = value >> 8;
                    src[x*4+3] = value;
                }
                else {
                    src[x*4+3] = value >> 24;
                    src[x*4+2] = value >> 16;
                    src[x*4+1] = value >> 8;
                    src[x*4+0] = value;
                }
            }; break;
            default: break;
        }
    }
                         
    PixelFormat pixelFormat;
    unsigned int width;
    unsigned int height;
    unsigned int bytesPerLine;
    unsigned char *data;
};


class FramebufferPixel
{
    public:
        FramebufferPixel( Framebuffer *_fb, int _x, int _y)
          : fb(_fb)
          , x(_x)
          , y(_y)
        {
            cs = (pixelFormat.bits_per_pixel + 7) >> 3;
            rs = fb->bytesPerLine;
            p = fb->data + y * rs + x * cs;
        }
        
        void setColor( unsigned int r,
                       unsigned int g,
                       unsigned int b,
                       unsigned int m = 255 )
        {
        }

        void getColor( unsigned int &r,
                       unsigned int &g,
                       unsigned int &b,
                       unsigned int m = 255 )
        {
        }
       
        void up() { p -= rs; y--; }
        void down() { p += rs; y++; }
        void left() { p -= cs; x--; }
        void right() { p += cs; x++; }
        
        Framebuffer *fb;
        int x, y;
        unsigned char *p;
        unsigned int cs;
        unsigned int rs;
}


int saveFramebufferAsPPM( int file, Framebuffer *fb,
                          int x0 = 0,
                          int y0 = 0,
                          int width = -1,
                          int height = -1 );

}

#endif // _hexonet_Framebuffer_h_
