/*
 * Resource Manager protocol
 *
 * Copyright (C) 2001-2002, Olaf Kirch <okir@lst.de>
 */

#ifndef RESMGR_PROTO_H
#define RESMGR_PROTO_H

#include <stdarg.h>
#include <sys/socket.h>
#include "resmgr.h"

/* Response codes for resource manager protocol */
enum respcodes {
	MSG_OKAY	= 100,	/* success */

	MSG_NODEVS	= 200,	/* no devices available to user */
	MSG_NOSESS	= 201,	/* no sessions */
	MSG_STALELOCK	= 202,	/* stale lock file */

	MSG_ERROR	= 500,	/* general error */
	MSG_SYNTAX	= 501,	/* syntax error */
	MSG_DENIED	= 502,	/* not allowed */
};

#define _PATH_RESMGR_SOCKET	"/var/run/.resmgr_socket"

struct conn {
	struct conn *	next;
	int		fd;
	int		passfd;
	struct ucred	cred;
	unsigned int	broadcast : 1,
			acceptfd  : 1,
			debug     : 1;
	char		user[32];
	char		group[32];
	struct res_user *ruser;
	char		buffer[256];
};

extern struct conn *	rsm_connect(const char *);
extern int		rsm_recv(struct conn *, char *, unsigned int);
extern int		rsm_recv_response(struct conn *);
extern int		rsm_send(struct conn *, const char *, size_t);
extern int		rsm_check(struct conn *, const char *);
extern void		rsm_queue_fd(struct conn *, int);
extern void		rsm_close(struct conn *);
extern void		rsm_destroy(struct conn *);
extern int		rsm_printf(struct conn *, const char *, ...);
extern int		rsm_vprintf(struct conn *, const char *, va_list);

extern void		rsm_close_stream(struct conn *);

#endif /* RESMGR_PROTO_H */
