/*
 * $Id: pam_resmgr.c,v 1.6 2003/03/05 13:32:19 okir Exp $
 *
 * Copyright (C) 2001-2002, Olaf Kirch <okir@lst.de>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include <security/pam_modules.h>
#include "protocol.h"


int
pam_sm_open_session(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
	char	namebuf[64];
	char	*tty, *user;
	int	rc, n;

	if ((rc = pam_get_item(pamh, PAM_TTY, (const void **) &tty)) != PAM_SUCCESS
	 || (rc = pam_get_item(pamh, PAM_USER, (const void **) &user)) != PAM_SUCCESS) {
		syslog(LOG_WARNING, "failed to get item: %s",
				pam_strerror(pamh, rc));
		return PAM_SUCCESS;
	}
	if (user == NULL)
		return PAM_SUCCESS;

	/* Work around sshd's use of NODEVssh */
	for (n = 0; n < argc; n++) {
		if (!strcmp(argv[n], "fake_ttyname")) {
			sprintf(namebuf, "rsmid%u", getpid());
			tty = namebuf;
		}
	}

	if (!tty && !(tty = ttyname(0)))
		return PAM_SUCCESS;

	if (rsm_login(user, tty) < 0) {
		syslog(LOG_WARNING, "resmgr login failed");
		return PAM_SUCCESS;
	}

	for (n = 0; n < argc; n++) {
		const char	*clsname;

		if (strncmp(argv[n], "grant=", 6))
			continue;
		clsname = argv[n] + 6;
		if (rsm_grant(user, clsname) < 0) {
			syslog(LOG_WARNING,
				"failed to grant %s access to "
				"resource class %s",
				user, clsname);
		}
	}

	return PAM_SUCCESS;
}

int
pam_sm_close_session(pam_handle_t * pamh, int flags, int argc, const char **argv)
{
	char	namebuf[64];
	char	*tty;
	int	n, rc;

	if ((rc = pam_get_item(pamh, PAM_TTY, (const void **) &tty)) != PAM_SUCCESS) {
		syslog(LOG_WARNING, "failed to get item: %s",
				pam_strerror(pamh, rc));
		return PAM_SUCCESS;
	}

	/* Work around sshd's use of NODEVssh */
	for (n = 0; n < argc; n++) {
		if (!strcmp(argv[n], "fake_ttyname")) {
			sprintf(namebuf, "rsmid%u", getpid());
			tty = namebuf;
		}
	}

	if (!tty && !(tty = ttyname(0)))
		return PAM_SUCCESS;

	if (rsm_logout(tty) < 0) {
		syslog(LOG_WARNING, "resmgr logout failed");
		return PAM_SUCCESS;
	}

	return PAM_SUCCESS;
}
